/****    StrSelect.h    ****/

/****    public declarations/definitions for StrSelect.c    ****/

#ifndef	_XiStrSelect_h
#define	_XiStrSelect_h	1

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/

/********************************************************************
This widget implements a string selection box.  The basic idea is
that a string/buffer can be displayed in a window (a simple
pixmap-based widget) with client-specified line/row delimiters.
One possible usage for this widget would be the display of
filenames in a window.
   The string selection box allows the user to select an entry from
the window; by default, a click-left operation makes a selection.
The selected entry is highlighted in reverse video.  The public
function XiStrSelectGetSelection() retrieves the currently selected
entry.
   The application programmer can specify the reference string in
one of two ways:  (1) the resource XiNreferenceString can be set to
point to the client string, or (2) the public function
XiStrSelectSetString() can be used change the reference string
dynamically.  The reference string must exist external to the
string selection box widget.  The string selection box makes a
private copy of the reference string, because it uses strtok() to
break the string into rows.
   A convenience function, XiStrSelectPopup() is available for
popping up the string selection box, IF it resides in a top-level
shell.  (This function simply invokes XtPopup() on the parent of
the string selection widget.  This function would not be useful,
if, for example, the string selection widget is a child of, say,
a viewport.
   Note that the pixmap cannot be resized.  Typically, the client
would create the pixmap inside a viewport and, possibly, allow the
viewport to be resized.  There are no limits on the size of the
reference string and the selected string--they are maintained in
dynamically allocated primary storage.
   An application may need to make preparations for a StrSelect
widget's handing of font dimensions.  Specifically, a StrSelect
widget adds spacing to the height of the specified font in
determining the height of a row within the pixmap; see the
XiNrowSpacing resource below.  Thus, in some cases, a higher level
widget that uses a StrSelect widget may need to make its own
row/column size determinations in order to coordinate its own
dimensions with those of the pixmap.  Note that you can set the
row spacing to 0, if you don't want the spacing to be added.
   The client program can use resources to set the font, the size
of the box in row/column metrics, the delimiters that break the
string into rows, the pixmap cursor, etc.  Most of the resources
are used only during widget creation.
   Several of the calls to fprintf() are "optional."

Resources:

Name			Class			Data Type		Default		Modify?
----			-----			---------		-------		-------
XiNreference-	XiCReference-	String			"Nothing to	OK
String			String							display!"
XiNdelimiters	XiCDelimiters	String			"\n\r\t"	OK
XiNpixmapRows	XiCPixmapRows	int				50
XiNpixmapColumnsXiCPixmapColumnsint				100
XiNrowSpacing	XiCRowSpacing	int				2 (pixels)
XiNfont			XiCFont			XFontStruct *	XtDefaultFont
XiNforeground	XiCForeground	Pixel			XtDefaultForeground

   Public interfaces are described below.
********************************************************************/

#ifdef X11R3
#include <X11/Simple.h>
#else
#include <X11/Xaw/Simple.h>
#endif


/*
Resource definitions:
*/

#define XiNreferenceString	"referenceString"	/* OK to modify */
#define XiNdelimiters		"delimiters"		/* OK to modify */
#define XiNfont 			"font"
#define XiNforeground		"foreground"
#define XiNpixmapRows		"pixmapRows"
#define XiNpixmapColumns	"pixmapColumns"
#define XiNrowSpacing		"rowSpacing"
#define XiCReferenceString	"ReferenceString"
#define XiCDelimiters		"Delimiters"
#define XiCFont				"Font"
#define XiCForeground		"Foreground"
#define XiCPixmapRows		"PixmapRows"
#define XiCPixmapColumns	"PixmapColumns"
#define XiCRowSpacing		"RowSpacing"


typedef struct _XiStrSelectClassRec *XiStrSelectWidgetClass;
typedef struct _XiStrSelectRec *XiStrSelectWidget;

extern WidgetClass xiStrSelectWidgetClass;


/*
Public functions:
*/

extern void XiStrSelectPopup();
/*	XiStrSelectWidget str_select_widget;
*/

extern char *XiStrSelectGetSelection();
/*	XiStrSelectWidget str_select_widget;
*/

extern void XiStrSelectSetString();
/*	XiStrSelectWidget str_select_widget;
	char *string;
*/

extern void XiStrSelectRedisplay();
/*	XiStrSelectWidget str_select_widget;
*/

extern void XiStrSelectReset();
/*	XiStrSelectWidget str_select_widget;
*/


#endif /* _XiStrSelect_h  */
