/****    StrSelectP.h    ****/

/****    private declarations/definitions for StrSelect.c    ****/


#ifndef	_XiStrSelectP_h
#define	_XiStrSelectP_h


#include "StrSelect.h"
#ifdef X11R3
#include <X11/SimpleP.h>
#else
#include <X11/Xaw/SimpleP.h>
#endif


#define STR_NOTHING					"Nothing to display!"

#define STR_DEFAULT_WIDTH			300
#define STR_DEFAULT_HEIGHT			150

#define STR_DEFAULT_PIXMAP_ROWS		50
#define STR_DEFAULT_PIXMAP_COLUMNS	100
#define STR_DEFAULT_ROW_SPACING		2
#define STR_MIN_ROWS				2
#define STR_MIN_COLUMNS				5


#define STR_MAX_STR					500
#define STR_MAX_SELECTION			1000


#define STR_NO_HIGHLIGHT	-1	/* ignore mouse, just	*/
								/* redisplay strings	*/
#define STR_NO_STR			-2	/* no currently selected str */

#define STR_DELIMITERS	"\n\r\t"		/* used with strtok() */
#define EOS				'\0'


typedef struct _XiStrSelectClassPart {		/* class definition */
	int dummy;
} XiStrSelectClassPart;

typedef struct _XiStrSelectClassRec {
	CoreClassPart core_class;
	SimpleClassPart simple_class;
	XiStrSelectClassPart str_select_class;
} XiStrSelectClassRec;

extern XiStrSelectClassRec xiStrSelectClassRec;


typedef struct _XiStrSelectPart {		/* instance definition */
	Pixel foreground;
	char *str;							/* the string/buffer */
	char *buffer;						/* internal copy of str,	*/
										/* strtok() modifies arg.	*/
	char *delimiters;					/* what separates each line */
	char *selection;					/* holds current selection */
	XFontStruct *font;
	int pixmap_rows, pixmap_columns;	/* row/column metrics */
	int pixmap_width, pixmap_height;	/* pixel metrics */
	int row_spacing;					/* space between rows */
	int row_increment;					/* height of a row */
	Pixmap pixmap;
	GC gc;								/* regular text display GC */
	GC cgc;								/* clear text GC */
	GC hgc;								/* highlight text GC */
	int current_str;
	int current_num_strs;
} XiStrSelectPart;


typedef struct _XiStrSelectRec {
	CorePart core;
	SimplePart simple;
	XiStrSelectPart str_select;
} XiStrSelectRec;


#endif	/* _XiStrSelectP_h */
