/****  teststrsel.c  ****  tests the string selection box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#endif

#include <Ximisc.h>
#include "StrSelect.h"


/*
Functions:
*/

void Done(), Quit(), PrintSelection1(), PrintSelection2(),
	TestSelectBox1(), TestSelectBox2();


/*
Private globals:
*/

static Widget strSelectShell1, strSelectShell2,
	testSelectBox1, testSelectBox2,
	doneButton1, doneButton2;

static XFontStruct *font;

static char *test_str1 = "This is string selection box 1:\n\
Line 2\nLine 3\nLine 4";
static char *test_str2 = "This is string selection box 2:\n\
Line 2\nLine 3\nLine 4";


/*
main() sets up a button-activated string selection box.  A simple
callback is used to test the retrieval facilities for the
currently selected string.  NOTE:  It's important to test for
proper handling of multiple widgets, and to test both methods for
specifying a reference string.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, strSelectButton1, strSelectButton2,
		printButton1, printButton2, quitButton;
	Arg args[5];
	int i;
	char *delimiters = "\n";
	Cursor pixmap_cursor;

	topLevel = XtInitialize(argv[0], "TestStrSel",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "teststrsel", "8x13");
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	strSelectShell1 = XtCreatePopupShell("strSelectShell1",
		transientShellWidgetClass, topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	strSelectShell2 = XtCreatePopupShell("strSelectShell2",
		transientShellWidgetClass, topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XiNdelimiters, (XtArgVal) delimiters); i++;
	XtSetArg(args[i], XiNreferenceString, (XtArgVal) test_str1); i++;
	XtSetArg(args[i], XiNpixmapRows, (XtArgVal) 15); i++;
	XtSetArg(args[i], XiNpixmapColumns, (XtArgVal) 35); i++;
	testSelectBox1 = XtCreateManagedWidget("testSelectBox1",
		xiStrSelectWidgetClass, strSelectShell1, args, i);
	i = 0;
	XtSetArg(args[i], XiNfont, (XtArgVal) font); i++;
	XtSetArg(args[i], XiNpixmapRows, (XtArgVal) 5); i++;
	XtSetArg(args[i], XiNpixmapColumns, (XtArgVal) 31); i++;
/*	pixmap_cursor = XCreateFontCursor(XtDisplay(topLevel), XC_right_ptr);
	XtSetArg(args[i], XtNcursor, (XtArgVal) pixmap_cursor); i++;*/
	testSelectBox2 = XtCreateManagedWidget("testSelectBox2",
		xiStrSelectWidgetClass, strSelectShell2, args, i);
	XiStrSelectSetString(testSelectBox2, test_str2);
	testBox = XtCreateManagedWidget("box", boxWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Str Selection Box 1"); i++;
	strSelectButton1 = XtCreateManagedWidget("strSelectButton1",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(strSelectButton1, XtNcallback, TestSelectBox1, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Str Selection Box 2"); i++;
	strSelectButton2 = XtCreateManagedWidget("strSelectButton2",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(strSelectButton2, XtNcallback, TestSelectBox2, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Print Selection 1"); i++;
	printButton1 = XtCreateManagedWidget("printButton1",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(printButton1, XtNcallback, PrintSelection1, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Print Selection 2"); i++;
	printButton2 = XtCreateManagedWidget("printButton2",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(printButton2, XtNcallback, PrintSelection2, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Dismiss:  Box 1"); i++;
	doneButton1 = XtCreateManagedWidget("doneButton1",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(doneButton1, XtNcallback, Done, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Dismiss:  Box 2"); i++;
	doneButton2 = XtCreateManagedWidget("doneButton2",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(doneButton2, XtNcallback, Done, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	quitButton = XtCreateManagedWidget("quitButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quitButton, XtNcallback, Quit, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void TestSelectBox1(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiStrSelectPopup(testSelectBox1);
}	/* TestSelectBox1 */


/*ARGSUSED*/
void TestSelectBox2(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiStrSelectPopup(testSelectBox2);
}	/* TestSelectBox2 */


/*ARGSUSED*/
void PrintSelection1(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	char *selection = XiStrSelectGetSelection(testSelectBox1);

	printf("The current selection is: %s\n",
		(selection) ? selection : "");
}	/* PrintSelection1 */


/*ARGSUSED*/
void PrintSelection2(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	char *selection = XiStrSelectGetSelection(testSelectBox2);

	printf("The current selection is: %s\n",
		(selection) ? selection : "");
}	/* PrintSelection2 */


/*ARGSUSED*/
void Done(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	if (w == doneButton1)
		XtPopdown(strSelectShell1);
	else if (w == doneButton2)
		XtPopdown(strSelectShell2);
}	/* Done */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

