/****  xconvert.c  ****/

/*
xconvert is a demo program that tests the choice box and
text entry widgets.  It allows the user to enter an integer
and convert it to a different numeric base.
   The previous numeric base, that is, the base to use in
converting the displayed text to a new base, is stored in
the variable old_base.  At start-up, old_base == DEC.
*/


#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif
#include <Ximisc.h>
#include "Alert.h"
#include "Choice.h"
#include "SimpleText.h"


#define EOS	'\0'

#define MAX_STR	100

#define BIN	2
#define OCT	8
#define DEC	10
#define HEX	16


/*
Functions:
*/

void Clear(), Convert(), Quit(), UpdateBase();

char *integer_to_bin_str();
int bin_str_to_integer();



/*
Private globals:
*/

static Widget alertBox, baseSelection, textEntry;

static XiChoiceItem item_list[] = {	/* alphabetical ordering */
	{"Bin", BIN, UpdateBase, NULL},
	{"Dec", DEC, UpdateBase, NULL},
	{"Hex", HEX, UpdateBase, NULL},
	{"Oct", OCT, UpdateBase, NULL},
	{NULL, NULL, NULL, NULL},
};

static int old_base = DEC, base = DEC;


/*
main() builds the converter within a form widget.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, alertShell, convertBox, clearBtn, convertBtn,
		quitBtn;
	Arg args[10];
	int i;

	topLevel = XtInitialize(argv[0], "XConvert",
		NULL, 0, &argc, argv);
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShell = XtCreatePopupShell("alertShell",
		transientShellWidgetClass, topLevel, args, i);
	i = 0;
	alertBox = XtCreateManagedWidget("alertBox",
		xiAlertWidgetClass, alertShell, args, i);
	XiAlertAddButton(alertBox, "Continue", 0, NULL, NULL);
	convertBox = XtCreateManagedWidget("convertBox", formWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Integer:"); i++;
	XtSetArg(args[i], XiNtextWidth, (XtArgVal) 130); i++;
	XtSetArg(args[i], XiNtext, (XtArgVal) ""); i++;
	textEntry = XtCreateManagedWidget("textEntry",
		xiSimpleTextWidgetClass, convertBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) textEntry); i++;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "   Base:"); i++;
	XtSetArg(args[i], XiNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XiNitemBorderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XiNexclusive, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XiNdefaultItem, (XtArgVal) 2); i++;	/* DEC */
	XtSetArg(args[i], XiNlabelOnLeft, (XtArgVal) TRUE); i++;
	baseSelection = XtCreateManagedWidget("baseSelection",
		xiChoiceWidgetClass, convertBox, args, i);
	XiChoiceAddItems(baseSelection, item_list);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) baseSelection); i++;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Clear"); i++;
	clearBtn = XtCreateManagedWidget("clearBtn",
		commandWidgetClass, convertBox, args, i);
	XtAddCallback(clearBtn, XtNcallback, Clear, NULL);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) baseSelection); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) clearBtn); i++;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Convert"); i++;
	convertBtn = XtCreateManagedWidget("convertBtn",
		commandWidgetClass, convertBox, args, i);
	XtAddCallback(convertBtn, XtNcallback, Convert, NULL);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) baseSelection); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) convertBtn); i++;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	quitBtn = XtCreateManagedWidget("quitBtn",
		commandWidgetClass, convertBox, args, i);
	XtAddCallback(quitBtn, XtNcallback, Quit, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*
Clear() clears out the display.
*/
/*ARGSUSED*/
void Clear(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiSimpleTextSetString(textEntry, "");
}	/* Clear */


/*
Convert() interprets the value in the display based on the
value of old_base, replacing the displayed value with the
converted value.
*/
/*ARGSUSED*/
void Convert(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	static char output[MAX_STR];
	char *text;
	int number, result;

	text = XiSimpleTextGetString(textEntry);
	if (!strlen(text))
		return;
	if (old_base == HEX)
		result = sscanf(text, "%x", &number);
	else if (old_base == OCT)
		result = sscanf(text, "%o", &number);
	else if (old_base == BIN)
		 number = bin_str_to_integer(text, &result);
	else
		result = sscanf(text, "%d", &number);
	if (result == 0) {
		XiAlertPopup(alertBox,
			"Invalid data for the specified numeric base.",
			XiNOBEEP);
		return;
	}
	if (base == HEX)
		sprintf(output, "%x", number);
	else if (base == OCT)
		sprintf(output, "%o", number);
	else if (base == BIN)
		sprintf(output, "%s", integer_to_bin_str(number));
	else
		sprintf(output, "%d", number);
	XiSimpleTextSetString(textEntry, output);
}	/* Convert */


/*
UpdateBase() maintains the current and previous bases.
*/
/*ARGSUSED*/
void UpdateBase(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	old_base = base;
	base = XiChoiceGetValue(baseSelection,
		XiChoiceGetSelectedItem(baseSelection));
}	/* UpdateBase */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	exit(0);
}	/* Quit */


/*
integer_to_bin_str() converts an integer to a binary string.
*/

char *integer_to_bin_str(n)
int n;
{
	static char bin_str[MAX_STR];
	int i, j = 0;

	if (n) {
		for (i = 31; i > -1; i--) {
			bin_str[i] = (n & 1) ? '1' : '0';
			n >>= 1;
		}
		for (i = 0; i < 32 && bin_str[i] == '0'; i++)
			;
		for ( ; bin_str[i]; i++, j++)
			bin_str[j] = bin_str[i];
	}
	else
		bin_str[j++] = '0';
	bin_str[j] = EOS;
	return bin_str;	
}	/* integer_to_bin_str */


/*
bin_str_to_integer() converts a binary string to an integer.
*/

int bin_str_to_integer(bin_str, convert_ok)
char *bin_str;
int *convert_ok;
{
	*convert_ok = TRUE;		/* not relevant at present */
	return (int)strtol(bin_str, (char **)NULL, 2);
}	/* bin_str_to_integer */



