/****  xdelete.c  ****  tests the file selection box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>


#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif

#include "Ximisc.h"
#include "Alert.h"
#include "FileSelect.h"


/*
Functions:
*/

void Quit(), RemoveFile();

/*
Private globals:
*/

static Widget alertBox, deleteFileBox;


/*
main() sets up a button-activated file selection box inside a
box widget in the main window.  A simple callback is used to
perform the file deletion.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, alertShell, deleteBox, quitButton;
	Arg args[3];
	int i;

	topLevel = XtInitialize(argv[0], "XDelete",
		NULL, 0, &argc, argv);
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShell = XtCreatePopupShell("alertShell",
		transientShellWidgetClass, topLevel, args, i);
	i = 0;
	alertBox = XtCreateManagedWidget("alertBox",
		xiAlertWidgetClass, alertShell, args, i);
	XiAlertAddButton(alertBox, "Continue", 0, NULL, NULL);
	deleteBox = XtCreateManagedWidget("deleteBox", formWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XiNrows, (XtArgVal) 15); i++;	
	XtSetArg(args[i], XiNcolumns, (XtArgVal) 30); i++;	
	deleteFileBox = XtCreateManagedWidget("deleteFileBox",
		xiFileSelectWidgetClass, deleteBox, args, i);
	XiFileSelectAddApplyProc(deleteFileBox, RemoveFile);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) deleteFileBox); i++;
	quitButton = XtCreateManagedWidget("quitButton",
		commandWidgetClass, deleteBox, args, i);
	XtAddCallback(quitButton, XtNcallback, Quit, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*
RemoveFile() unlinks the file specified by the current selection.
*/
/*ARGSUSED*/
void RemoveFile(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	char *filename = XiFileSelectGetSelection(deleteFileBox);

	if (!*filename) {
		XiAlertPopup(alertBox,
			"You must select a file first.",
			XiNOBEEP);
		return;
	}
	unlink(filename);
	XiFileSelectRefresh(deleteFileBox);
}	/* RemoveFile */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	exit(0);
}	/* Quit */

