/****    alert.c    ****    simple alert box implementation    ****/


#include "alert.h"


/*
Private functions:
*/

static int get_alert_result();
static void alert_reset_proper_keyboard_focus();


/*
Private globals:
*/

static Widget alertShellYesNoCancel, alertShellContinue,
	alertLabelYesNoCancel, alertLabelContinue,
	alertYesNoCancel, alertContinue,
	alertButtonYes, alertButtonNo,
	alertButtonCancel, alertButtonContinue;


static int query_result;		/* holds the result of	*/
								/* an alert box query	*/
static int query_wait;			/* controls the blocking	*/
								/* activity of an alert box	*/

static Widget ync_parent, continue_parent;

/*
This is a pointer to a function to execute if the keyboard focus
needs resetting after pop-up operations.  See the functions
set_alert_reset_proper_keyboard_focus() and
alert_reset_proper_keyboard_focus() in this module.
*/

static void (*reset_keyboard_focus_proc)();



/*
alert_create_ync() creates a yes-no-cancel, three-button alert box.
*/

void alert_create_ync(parent)
Widget parent;
{
	Arg args[3];
	int i;

	ync_parent = parent;
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShellYesNoCancel = XtCreatePopupShell("alertShellYesNoCancel",
		transientShellWidgetClass, parent, args, i);
	alertYesNoCancel = XtCreateManagedWidget("alertYesNoCancel",
		formWidgetClass, alertShellYesNoCancel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNresize, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XtNresizable, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	alertLabelYesNoCancel = 
		XtCreateManagedWidget("alertLabelYesNoCancel",
			labelWidgetClass, alertYesNoCancel, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Yes"); i++;
	XtSetArg(args[i], XtNfromVert,
		(XtArgVal) alertLabelYesNoCancel); i++;
	alertButtonYes = XtCreateManagedWidget("alertButtonYes",
		commandWidgetClass, alertYesNoCancel, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "No"); i++;
	XtSetArg(args[i], XtNfromVert,
		(XtArgVal) alertLabelYesNoCancel); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) alertButtonYes); i++;
	alertButtonNo = XtCreateManagedWidget("alertButtonNo",
		commandWidgetClass, alertYesNoCancel, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Cancel"); i++;
	XtSetArg(args[i], XtNfromVert,
		(XtArgVal) alertLabelYesNoCancel); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) alertButtonNo); i++;
	alertButtonCancel = XtCreateManagedWidget("alertButtonCancel",
		commandWidgetClass, alertYesNoCancel, args, i);
	XtAddCallback(alertButtonYes, XtNcallback,
		AlertYesNoCancel, NULL);
	XtAddCallback(alertButtonNo, XtNcallback,
		AlertYesNoCancel, NULL);
	XtAddCallback(alertButtonCancel, XtNcallback,
		AlertYesNoCancel, NULL);
}	/* alert_create_ync */


/*
alert_create_continue() creates a one-button alert box.
*/

void alert_create_continue(parent)
Widget parent;
{
	Arg args[3];
	int i;

	continue_parent = parent;
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShellContinue = XtCreatePopupShell("alertShellContinue",
		transientShellWidgetClass, parent, args, i);
	alertContinue = XtCreateManagedWidget("alertContinue",
		formWidgetClass, alertShellContinue, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNresize, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XtNresizable, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	alertLabelContinue = XtCreateManagedWidget("alertLabelContinue",
		labelWidgetClass, alertContinue, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Continue"); i++;
	XtSetArg(args[i], XtNfromVert,
		(XtArgVal) alertLabelContinue); i++;
	alertButtonContinue =
		XtCreateManagedWidget("alertButtonContinue",
			commandWidgetClass, alertContinue, args, i);
	XtAddCallback(alertButtonContinue, XtNcallback,
		AlertContinue, NULL);
}	/* alert_create_continue */


/*
AlertYesNoCancel() determines which option has been selected
in a dialog window and resets the `wait' variable; it works
with alert_query().
*/
/*ARGSUSED*/
void AlertYesNoCancel(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XtPopdown(alertShellYesNoCancel);
	alert_reset_proper_keyboard_focus();
	if (w == alertButtonYes)
		query_result = ALERT_YES;
	else if (w == alertButtonNo)
		query_result = ALERT_NO;
	else if (w == alertButtonCancel)
		query_result = ALERT_CANCEL;
	query_wait = FALSE;
}	/* AlertYesNoCancel */


/*
AlertContinue() terminates the pop-up message window
invoked by alert().
*/
/*ARGSUSED*/
void AlertContinue(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XtPopdown(alertShellContinue);
	alert_reset_proper_keyboard_focus();
	query_wait = FALSE;
}	/* AlertContinue */


/*
set_alert_reset_proper_keyboard_focus() establishes a pointer to
the client's procedure that handles keyboard focus operations.
See the procedure alert_reset_proper_keyboard_focus().
*/

void set_alert_reset_proper_keyboard_focus(rkfp)
void (*rkfp)();
{
	reset_keyboard_focus_proc = rkfp;
}	/* set_alert_reset_proper_keyboard_focus */


/*
alert() pops up a message window; it works with AlertContinue().
*/

void alert(message)
char *message;
{
	Arg args[3];
	int i;
	Window dummy_w;
	int root_x, root_y, dummy_xy;
	unsigned int dummy_keys;

	XQueryPointer(XtDisplay(continue_parent),
		XtWindow(continue_parent), &dummy_w, &dummy_w, &root_x,
		&root_y, &dummy_xy, &dummy_xy, &dummy_keys);
	i = 0;
	XtSetArg(args[i], XtNx, (XtArgVal) (root_x - 20)); i++;
	XtSetArg(args[i], XtNy, (XtArgVal) (root_y - 20)); i++;
	XtSetValues(alertShellContinue, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) message); i++;
	XtSetValues(alertLabelContinue, args, i);
	XtPopup(alertShellContinue, XtGrabExclusive);
}	/* alert */


/*
alert_query() pops up a dialog window;
it works with AlertYesNoCancel().
*/

int alert_query(message)
char *message;
{
	Arg args[3];
	int i;
	Window dummy_w;
	int root_x, root_y, dummy_xy;
	unsigned int dummy_keys;

	XQueryPointer(XtDisplay(ync_parent),
		XtWindow(ync_parent), &dummy_w, &dummy_w, &root_x,
		&root_y, &dummy_xy, &dummy_xy, &dummy_keys);
	i = 0;
	XtSetArg(args[i], XtNx, (XtArgVal) (root_x - 20)); i++;
	XtSetArg(args[i], XtNy, (XtArgVal) (root_y - 20)); i++;
	XtSetValues(alertShellYesNoCancel, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) message); i++;
	XtSetValues(alertLabelYesNoCancel, args, i);
	XtPopup(alertShellYesNoCancel, XtGrabExclusive);
	return get_alert_result();
}	/* alert_query */


/*
alert_beep() rings the system bell n times.
*/

void alert_beep(num_beeps)
int num_beeps;
{
	while (num_beeps-- > 0)
		XBell(XtDisplay(continue_parent), 80);
}	/* alert_beep */


/*
get_alert_result() is a pop-up window function for waiting on the
user's selection to the yes-no-cancel alert query.
*/

static int get_alert_result()
{
	XEvent event;

	query_wait = TRUE;				/* block until the user	*/
	while (query_wait) {			/* presses a button		*/
		XtNextEvent(&event);
		XtDispatchEvent(&event);
	}
	return query_result;
}	/* get_alert_result */


/*
alert_reset_proper_keyboard_focus() allows the keyboard focus to be
reestablished after after a transient shell is popped up and down.
Calling this routine is necessary with twm, but not with uwm.
*/

static void alert_reset_proper_keyboard_focus()
{
	if (reset_keyboard_focus_proc == NULL)
		return;
	reset_keyboard_focus_proc();
}	/* alert_reset_proper_keyboard_focus */


