/****    delete.c    ****/


/********************************************************/
/* DELETE implement a two-stage file deletion system. 	*/
/* See the complementary module waste.c.				*/
/********************************************************/


#include "commondel.h"
#include "delete.h"


/*
main() allows the user to delete a set of files matching
a wildcard spec.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	if (argc < 2) {
		fprintf(stderr, "Usage: delete <file specification>\n");
		exit(-1);
	}
	if (!get_home_directory(home_directory))
		exit(-1);
	max_basket_entries = get_max_files();
	delete_filenames(argc, argv);
	exit(0);
}	/* main */


/*
delete_filenames() applies delete_file() to
each filename from the command line expansion.
*/

void delete_filenames(argc, argv)
int argc;
char *argv[];
{
	char file_spec[MAX_CHARS];
	int continue_deletions = TRUE;

	while (--argc > 0 && continue_deletions) {
		build_file_spec(file_spec, *++argv);
		continue_deletions = delete_file(file_spec);
	}
}	/* delete_filenames */

	
/*
delete_file() is used to delete files using
an interactive prompt.
*/

int delete_file(file_spec)
char *file_spec;
{
	char answer, answer_str[MAX_STR];

	if (file_size(file_spec) == -1) {
		fprintf(stderr, "No matching file(s).\n");
		return TRUE;
	}
	do {
		printf("Delete file: %s\nyes, no, or quit [y|n|q]? ",
			file_spec);
		gets(answer_str);
		answer = answer_str[0];
		if (islower(answer))
			answer = toupper(answer);
	} while (!isupper(answer) ||
				!(answer == 'Y' || answer == 'N' || answer == 'Q'));
	if (answer == 'Y')
		add_to_basket(file_spec);
	return (answer == 'Q') ? FALSE : TRUE;
}	/* delete_file */


/*
add_to_basket() puts the passed file spec. in the top of the
wastebasket, removing the oldest wastebasket contents, if
the wastebasket is overflowing.
*/

void add_to_basket(file_spec)
char *file_spec;
{
	FILE *waste_fd, *temp_waste_fd;
	char encoded_file_spec[MAX_CHARS];
	char temp_file_spec[MAX_CHARS];
	char temp_file_spec_2[MAX_CHARS];
	int position, waste_exists = FALSE;
	char *more_entries;

 	sprintf(temp_file_spec, "%s/%s", home_directory,
 		wastebasket_dir);
 	if (file_size(temp_file_spec) == -1)
 		mkdir(temp_file_spec, 0755);
 	sprintf(temp_file_spec, "%s/%s", home_directory,
 		wastebasket_file);
 	if (file_size(temp_file_spec) != -1) {
 		if ((waste_fd = fopen(temp_file_spec, "r")) != NULL)
 			waste_exists = TRUE;
 		else {
 			fprintf(stderr, "Error opening wastebasket!\n");
 			return;
 		}
 	}
 	sprintf(temp_file_spec, "%s/%s.%d",
 		home_directory, temp_wastebasket_file, getpid());
 	if ((temp_waste_fd = fopen(temp_file_spec, "w")) == NULL) {
 		fprintf(stderr,
 	"Error opening temporary file during wastebasket operations!\n");
 		return;
 	}
 
	encode_file_spec(encoded_file_spec, file_spec);
 	strcat(encoded_file_spec, "\n");
 	/* write the file spec. as the first wastebasket entry */
 	fputs(encoded_file_spec, temp_waste_fd);

 	if (waste_exists) {
 		more_entries = fgets(temp_file_spec, MAX_CHARS, waste_fd);
		for (position = 1; more_entries != NULL; position++) {
			if (position < max_basket_entries) {
				if (strcmp(encoded_file_spec, temp_file_spec) != 0)
					/* not a duplicate */
					fputs(temp_file_spec, temp_waste_fd);
			}
			else {
				temp_file_spec[strlen(temp_file_spec) - 1] = EOS;
				sprintf(temp_file_spec_2, "%s/%s/%s",
					home_directory, wastebasket_dir, temp_file_spec);
				unlink(temp_file_spec_2);
			}
 			more_entries = fgets(temp_file_spec, MAX_CHARS, waste_fd);
		}
		fclose(waste_fd);
	}
	fclose(temp_waste_fd);
	encoded_file_spec[strlen(encoded_file_spec) - 1] = EOS;
	sprintf(temp_file_spec, "%s/%s/%s",
		home_directory, wastebasket_dir, encoded_file_spec);
	rename(file_spec, temp_file_spec);
	sprintf(temp_file_spec_2, "%s/%s.%d",
		home_directory, temp_wastebasket_file, getpid());
	sprintf(temp_file_spec, "%s/%s",
		home_directory, wastebasket_file);
	rename(temp_file_spec_2, temp_file_spec);
}	/* add_to_basket */


/*
build_file_spec() concatenates a path and a file specification.
*/

void build_file_spec(file_spec, partial_file_spec)
char *file_spec, *partial_file_spec;
{
	if (*partial_file_spec == '/')
		strcpy(file_spec, partial_file_spec);
	else {
		getwd(file_spec);
		strcat(file_spec, "/");
		strcat(file_spec, partial_file_spec);
	}
}	/* build_file_spec */

