/****    xwaste.bskt.c    ****/

/**** basket-related routines for xwaste.c    ****/


#include "xwaste.bskt.h"


/*
Private globals:
*/

static Pixmap wastebasket;	/* off-screen image for wastebasket */
static GC wgc, cgc, hgc;	/* see basket_create_offscreen_pixmap() */

static Widget wbrw;		/* wastebasket reference widget--used	*/
						/* in an XtDisplay(wbrw)-type capacity	*/

static int row_increment, current_file;
static unsigned int basket_width, basket_height;


/*
basket_create_offscreen_pixmap() creates and sets the dimensions
of the basket pixmap (the virtual basket image).
*/

void basket_create_offscreen_pixmap(w, font,
		pixmap_data, width, height)
Widget w;
XFontStruct *font;
ApplicationData pixmap_data;
unsigned int *width, *height;
{
	XGCValues values;
	Display *display = XtDisplay(w);
	int screen = XDefaultScreen(display);
	unsigned int depth = XDisplayPlanes(display, screen);

	values.foreground = XBlackPixel(display, screen);
	values.background = XWhitePixel(display, screen);
	values.font = font->fid;
	wgc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		GCForeground | GCBackground | GCFont, &values);
	cgc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		GCForeground | GCBackground | GCFont, &values);
	XSetFunction(XtDisplay(w), cgc, GXclear);
	values.foreground = XWhitePixel(display, screen);
	values.background = XBlackPixel(display, screen);
	hgc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		GCForeground | GCBackground | GCFont, &values);
	row_increment = font->max_bounds.ascent +
		font->max_bounds.descent + 2;
	*width = basket_width =
		pixmap_data.browser_columns * font->max_bounds.width;
	*height = basket_height =
		pixmap_data.browser_rows * row_increment;
	wastebasket = XCreatePixmap(XtDisplay(w),
		RootWindowOfScreen(XtScreen(w)), *width, *height, depth);
}	/* basket_create_offscreen_pixmap */


/*
basket_set_reference_widget() communicates the reference widget
for the wastebasket.
*/

void basket_set_reference_widget(w)
Widget w;
{
	wbrw = w;
}	/* basket_set_reference_widget */


/*
basket_reset_current_file() sets the "current file pointer"
to a null value.
*/

void basket_reset_current_file()
{
	current_file = NO_FILE;
}	/* basket_reset_current_file */


/*
basket_fill_with_filenames() fills the basket pixmap with the
names of the files stored in the wastebasket.
*/

int basket_fill_with_filenames(highlight_position)
int highlight_position;
{
	FILE *waste_fd;
	char file_spec[MAX_CHARS], temp_file_spec[MAX_CHARS];
	int len, offset;
	char *more_entries;

 	sprintf(file_spec, "%s/%s", home_directory, wastebasket_file);
 	if ((waste_fd = fopen(file_spec, "r")) == NULL) {
 		alert("The wastebasket is empty.");
 		return FALSE;
 	}
 	XFillRectangle(XtDisplay(wbrw), wastebasket, cgc, 0, 0,
 		basket_width, basket_height);
	current_file = NO_FILE;
	more_entries = fgets(file_spec, MAX_CHARS, waste_fd);
	for (offset = row_increment, current_num_files = 0;
			more_entries != NULL && offset < basket_height;
			offset += row_increment, current_num_files++) {
		decode_file_spec(temp_file_spec, file_spec);
		len = strlen(temp_file_spec) - 1;	/* drop the <Return> */
		temp_file_spec[len] = EOS;
		XDrawImageString(XtDisplay(wbrw), wastebasket, wgc,
			0, offset, temp_file_spec, len);
		if (highlight_position != NO_HIGHLIGHT)
			if (highlight_position == current_num_files) {
				/* this is it */
				XDrawImageString(XtDisplay(wbrw), wastebasket,
					hgc, 0, offset, temp_file_spec, len);
				current_file = current_num_files;
			}
 		more_entries = fgets(file_spec, MAX_CHARS, waste_fd);
	}
	fclose(waste_fd);
	XCopyArea(XtDisplay(wbrw), wastebasket, XtWindow(wbrw),
		wgc, 0, 0, basket_width, basket_height, 0, 0);
	return TRUE;
}	/* basket_fill_with_filenames */


/*
basket_select_file() calculates the "row" offset for
a filename and then calls basket_fill_with_filenames() to
either clear the current highlighted file or highlight
another file, depending on the legitimacy of the position.
*/

void basket_select_file(event)
XEvent *event;
{
	int highlight_position;

	highlight_position = event->xbutton.y / row_increment;
	if (highlight_position > current_num_files)
		basket_fill_with_filenames(NO_HIGHLIGHT);
	else
		basket_fill_with_filenames(highlight_position);
}	/* basket_select_file */


/*
basket_restore_file() copies a file in the wastebasket back to
its original directory--the wastebasket entry is NOT deleted.
*/

void basket_restore_file()
{
	FILE *waste_fd;
	char cmd_string[MAX_CHARS];
	char file_spec[MAX_CHARS];
	char decoded_file_spec[MAX_CHARS];
	int position;
	char *more_entries;

	if (current_file == NO_FILE) {
		alert("First, you must click left to select a filename.");
 		return;
 	}
 	sprintf(file_spec, "%s/%s", home_directory, wastebasket_file);
 	if ((waste_fd = fopen(file_spec, "r")) == NULL) {
 			alert("The wastebasket is empty.");
 			return;
 	}
 	if ((more_entries = fgets(file_spec, MAX_CHARS, waste_fd))
 			== NULL) {
 		alert("The wastebasket is empty.");
		fclose(waste_fd);
 		return;
 	}
	for (position = 0;
			more_entries != NULL && position < current_file;
			position++)
 		more_entries = fgets(file_spec, MAX_CHARS, waste_fd);
	if (position == current_file) {
		file_spec[strlen(file_spec) - 1] = EOS;
		decode_file_spec(decoded_file_spec, file_spec);
		sprintf(cmd_string, "cp %s/%s/%s %s",
				home_directory, wastebasket_dir, file_spec,
				decoded_file_spec);
		system(cmd_string);
	}
	fclose(waste_fd);
	basket_fill_with_filenames(NO_HIGHLIGHT);
}	/* basket_restore_file */


/*
basket_delete_file() permanently deletes a file from
the wastebasket directory.
*/

void basket_delete_file()
{
	FILE *waste_fd, *temp_waste_fd;
	char temp_file_spec[MAX_CHARS];
	char file_spec[MAX_CHARS];
	int position;
	char *more_entries;

	if (current_file == NO_FILE) {
		alert("First, you must click left to select a filename.");
 		return;
 	}
 	sprintf(file_spec, "%s/%s", home_directory, wastebasket_file);
 	if ((waste_fd = fopen(file_spec, "r")) == NULL) {
 			alert("The wastebasket is empty.");
 			return;
 	}
 	sprintf(temp_file_spec, "%s/%s.%d", home_directory,
 		temp_wastebasket_file, getpid());
 	if ((temp_waste_fd = fopen(temp_file_spec, "w")) == NULL) {
 		alert(
 	"Error opening temporary file during wastebasket operations!");
 		fclose(waste_fd);
 		return;
 	}
 	if ((more_entries = fgets(file_spec, MAX_CHARS, waste_fd))
 			== NULL) {
 		alert("The wastebasket is empty.");
 		fclose(waste_fd);
 		fclose(temp_waste_fd);
 		return;
 	}

	for (position = 0; more_entries != NULL; position++) {
		if (position == current_file ||
				position >= max_basket_entries) {
			file_spec[strlen(file_spec) - 1] = EOS;
			sprintf(temp_file_spec, "%s/%s/%s",
					home_directory, wastebasket_dir, file_spec);
			unlink(temp_file_spec);
		}
		else
			fputs(file_spec, temp_waste_fd);
 		more_entries = fgets(file_spec, MAX_CHARS, waste_fd);
	}
	fclose(waste_fd);
	fclose(temp_waste_fd);
	sprintf(temp_file_spec, "%s/%s.%d",
			home_directory, temp_wastebasket_file, getpid());
	sprintf(file_spec, "%s/%s",
			home_directory, wastebasket_file);
	rename(temp_file_spec, file_spec);
	basket_fill_with_filenames(NO_HIGHLIGHT);
}	/* basket_delete_file */


/*
basket_add_file() puts the passed file spec. in the top of the
wastebasket, removing the oldest wastebasket contents, if the
wastebasket is overflowing.
*/

void basket_add_file(file_spec)
char *file_spec;
{
	FILE *waste_fd, *temp_waste_fd;
	char encoded_file_spec[MAX_CHARS];
	char temp_file_spec[MAX_CHARS];
	char temp_file_spec_2[MAX_CHARS];
	int position, waste_exists = FALSE;
	char *more_entries;

 	sprintf(temp_file_spec, "%s/%s", home_directory,
 		wastebasket_dir);
 	if (file_size(temp_file_spec) == -1)
 		mkdir(temp_file_spec, 0755); /* you may want to change this */
 	sprintf(temp_file_spec, "%s/%s", home_directory,
 		wastebasket_file);
 	if (file_size(temp_file_spec) != -1) {
 		if ((waste_fd = fopen(temp_file_spec, "r")) != NULL)
 			waste_exists = TRUE;
		else {
 			alert("Error opening wastebasket!");
 			return;
 		}
 	}
 	sprintf(temp_file_spec, "%s/%s.%d",
 		home_directory, temp_wastebasket_file, getpid());
 	if ((temp_waste_fd = fopen(temp_file_spec, "w")) == NULL) {
 		alert(
 	"Error opening temporary file during wastebasket operations!");
 		return;
 	}
 
	encode_file_spec(encoded_file_spec, file_spec);
 	strcat(encoded_file_spec, "\n");
 	/* write the file spec. as the first wastebasket entry */
 	fputs(encoded_file_spec, temp_waste_fd);
 											
 	if (waste_exists) {
 		more_entries = fgets(temp_file_spec, MAX_CHARS, waste_fd);
		for (position = 1; more_entries != NULL; position++) {
			if (position < max_basket_entries) {
				if (strcmp(encoded_file_spec, temp_file_spec) != 0)
					/* not a duplicate */
					fputs(temp_file_spec, temp_waste_fd);
			}
			else {
				temp_file_spec[strlen(temp_file_spec) - 1] = EOS;
				sprintf(temp_file_spec_2, "%s/%s/%s",
					home_directory, wastebasket_dir, temp_file_spec);
				unlink(temp_file_spec_2);
			}
 			more_entries = fgets(temp_file_spec, MAX_CHARS, waste_fd);
		}
		fclose(waste_fd);
	}
	fclose(temp_waste_fd);
	encoded_file_spec[strlen(encoded_file_spec) - 1] = EOS;
	sprintf(temp_file_spec, "%s/%s/%s",
		home_directory, wastebasket_dir, encoded_file_spec);
	rename(file_spec, temp_file_spec);
	sprintf(temp_file_spec_2, "%s/%s.%d",
		home_directory, temp_wastebasket_file, getpid());
	sprintf(temp_file_spec, "%s/%s",
		home_directory, wastebasket_file);
	rename(temp_file_spec_2, temp_file_spec);
	basket_fill_with_filenames(NO_HIGHLIGHT);
}	/* basket_add_file */

