/****    xwaste.h    ****/

/****    external declarations for xwaste.c    ****/


/******************************************************/
/* XWASTE implement a two-stage file deletion system. */
/******************************************************/

#ifndef	XWASTE_H
#define	XWASTE_H	1

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Dialog.h>
#include <X11/Form.h>
#include <X11/VPaned.h>
#include <X11/Viewport.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#endif

#include <stdio.h>


#include "alert.h"
#include "commondel.h"
#include "xwaste.menu.h"
#include "xwaste.bskt.h"



#define MAX_STR					80
#define DEFAULT_BASKET_WIDTH	400			/* pixels */
#define DEFAULT_BASKET_HEIGHT	300			/* pixels */
#define POPUP_Y_OFFSET			25			/* pixels */


/*
Application resources:
*/

typedef struct {
	int browser_rows;
	int browser_columns;
	char *browser_font_name;
} ApplicationData, *ApplicationDataPtr;


#define XtNbrowserRows		"browserRows"
#define XtCBrowserRows		"BrowserRows"
#define XtNbrowserColumns	"browserColumns"
#define XtCBrowserColumns	"BrowserColumns"
#define XtNbrowserFont		"browserFont"
#define XtCBrowserFont		"BrowserFont"


/*
Function declarations:
*/

extern void	main(), process_resources(),
	reset_proper_keyboard_focus();
extern void create_main_panel_widgets(), create_basket_widgets();
extern void initialize_shell_structures();
extern void SelectFile(), MenuUp(), MenuDown(), Beep(), FillBasket();
extern void	Quit(), Delete(), Basket(), BasketDone();
extern char	*get_filename(), *get_updated_directory();
extern void expand_delete_filename();
extern int delete_file();


#endif

