/****    xwaste.menu.c    ****/

/****     menu-related routines for xwaste.c    ****/


#include "xwaste.menu.h"


/*
Private globals:
*/


static Widget menuShell, menuBox, menuButtonRestore,
	menuButtonDelete;


/*
menu_create() allocates the widgets for the basket menu
and sets up the callback functions.
*/

void menu_create(parent)
Widget parent;
{
	Arg args[3];
	int i;

	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	menuShell = XtCreatePopupShell("menuShell",
		transientShellWidgetClass, parent, args, i);
	menuBox = XtCreateManagedWidget("menuBox",
		boxWidgetClass, menuShell, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel,
		(XtArgVal) "Restore to Original Directory"); i++;
	menuButtonRestore = XtCreateManagedWidget("menuButtonRestore",
		commandWidgetClass, menuBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel,
		(XtArgVal) "Permanently Delete/Remove"); i++;
	menuButtonDelete = XtCreateManagedWidget("menuButtonDelete",
		commandWidgetClass, menuBox, args, i);
	XtAddCallback(menuButtonDelete, XtNcallback, MenuDelete, NULL);
	XtAddCallback(menuButtonRestore, XtNcallback, MenuRestore, NULL);
}	/* menu_create */


/*
menu_up() places and pops up the menu.
*/
/*ARGSUSED*/
void menu_up(w, event)
Widget w;
XButtonEvent *event;
{
	Arg args[3];
	int i;

	i = 0;
	XtSetArg(args[i], XtNx, (XtArgVal) (event->x_root - 20)); i++;
	XtSetArg(args[i], XtNy, (XtArgVal) (event->y_root - 20)); i++;
	XtSetValues(menuShell, args, i);
	XtPopup(menuShell, XtGrabNone);
}	/* menu_up */


/*
menu_down() removes the menu.
*/
/*ARGSUSED*/
void menu_down(w, event)
Widget w;
XButtonEvent *event;
{
	XtPopdown(menuShell);
	reset_proper_keyboard_focus();
}	/* menu_down */


/*
MenuDelete() permanently deletes a file.
*/
/*ARGSUSED*/
void MenuDelete(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	basket_delete_file();
	XtPopdown(menuShell);
	reset_proper_keyboard_focus();
}	/* MenuDelete */


/*
MenuRestore() restores a file to its original directory.
*/
/*ARGSUSED*/
void MenuRestore(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	basket_restore_file();
	XtPopdown(menuShell);
	reset_proper_keyboard_focus();
}	/* MenuRestore */

