/****    alert.c    ****    simple alert box implementation    ****/


#include "alert.h"



/*
Private globals:
*/

static Widget alertShellYesNoCancel, alertShellContinue;
static Widget alertYesNoCancel, alertContinue;


/*
alert_create_ync() creates a yes-no-cancel, three-button alert box.
*/

void alert_create_ync(parent)
Widget parent;
{
	Arg args[3];
	int i;

	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShellYesNoCancel = XtCreatePopupShell("alertShellYesNoCancel",
		transientShellWidgetClass, parent, args, i);
	alertYesNoCancel = XtCreateManagedWidget("alertYesNoCancel",
		xiAlertWidgetClass, alertShellYesNoCancel, NULL, 0);
	XiAlertAddButton(alertYesNoCancel, "Yes", ALERT_YES, NULL, NULL);
	XiAlertAddButton(alertYesNoCancel, "No", ALERT_NO, NULL, NULL);
	XiAlertAddButton(alertYesNoCancel, "Cancel", ALERT_CANCEL, NULL, NULL);
}	/* alert_create_ync */


/*
alert_create_continue() creates a one-button alert box.
*/

void alert_create_continue(parent)
Widget parent;
{
	Arg args[3];
	int i;

	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShellContinue = XtCreatePopupShell("alertShellContinue",
		transientShellWidgetClass, parent, args, i);
	alertContinue = XtCreateManagedWidget("alertContinue",
		xiAlertWidgetClass, alertShellContinue, NULL, 0);
	XiAlertAddButton(alertContinue, "Continue", NULL, NULL, NULL);
}	/* alert_create_continue */


/*
alert() pops up a message window.
*/

void alert(msg)
char *msg;
{
	XiAlertPopup(alertContinue, msg, XiNOBEEP);
}	/* alert */


/*
alert_query() pops up a dialog window.
*/

int alert_query(msg)
char *msg;
{
	return XiAlertPopup(alertYesNoCancel, msg, XiNOBEEP);
}	/* alert_query */


/*
alert_beep() rings the system bell n times.
*/

void alert_beep(num_beeps)
int num_beeps;
{
	XiAlertBeep(alertContinue, num_beeps);
}	/* alert_beep */


/*
set_alert_reset_proper_keyboard_focus() establishes a pointer to
the client's procedure that handles keyboard focus operations.
See the procedure alert_reset_proper_keyboard_focus().
*/

void set_alert_reset_proper_keyboard_focus(rkfp)
void (*rkfp)();
{
	XiAlertResetProperKeyboardFocus(rkfp);
}	/* set_alert_reset_proper_keyboard_focus */

