/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
** Create a simple polymorphic inheritance mechanism in ANSI C.
*/
#include <stdio.h>
#include <string.h>
#include <malloc.h>

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
** Define a root class with a two methods, GetName
** and FavoriteSaying.  This class is an abstract class
** since it provides no implementation of either function,
** rather just an interface.
*/
typedef struct tagObject *PObject;

/*
** Type-safe method prototypes.
*/
typedef char *(*PObject_GetName)( PObject pSelf );
typedef char *(*PObject_FavoriteSaying)( PObject pSelf );

typedef struct
{
	PObject_GetName 			GetName;
	PObject_FavoriteSaying 	FavoriteSaying;

} ObjectVTable, *PObjectVTable;

typedef struct tagObject
{
	PObjectVTable 	pVtbl;		// Object assumes only pointer to vtbl

} Object, *PObject;

#define Object_Do( pSelf, fn ) ((*((PObject)pSelf)->pVtbl->##fn)( (PObject)pSelf))

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
** Declare class derived from the base.
*/ 
typedef struct	tagPDevo
{
	Object		Base;						// Derivation gets sizeof(Base) bytes
	char			*FavSaying;				// Any additional data added after
} Devo, *PDevo;

char *Devo_GetName( PDevo pSelf );
char *Devo_FavoriteSaying( PDevo pSelf );

ObjectVTable DevoVTable =
{
	(PObject_GetName)Devo_GetName,
	(PObject_FavoriteSaying)Devo_FavoriteSaying
};

//
// Implement the methods for the new sub-class.
//
PDevo Devo_Construct( )
{
PDevo pSelf = (PDevo)malloc( sizeof(Devo) );
	if (pSelf)
		{
		// Initialize the vtbl of the new object
		((PObject)pSelf)->pVtbl = &DevoVTable;
		pSelf->FavSaying = "Whip it, into shape.";
		}
	return pSelf;
}

char *Devo_GetName( PDevo pSelf )
{
	return (char *)"Devo - the Band";
}

char *Devo_FavoriteSaying( PDevo pSelf )
{
	return (char *)pSelf->FavSaying;
}

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
** Declare a more complex class derived from the base.
** This derivation includes additional data members.
*/ 
typedef struct	tagPDogCow
{
	Object		Base;						// Derivation gets sizeof(Base) bytes
	char			DogCowTime[32];
	long 			DogCowArray[33];
	
} DogCow, *PDogCow;

char *DogCow_GetName( PDogCow pSelf );
char *DogCow_FavoriteSaying( PDogCow pSelf );

ObjectVTable DogCowVTable =
{
	(PObject_GetName)DogCow_GetName,
	(PObject_FavoriteSaying)DogCow_FavoriteSaying
};

PDogCow DogCow_Construct( )
{
PDogCow pSelf = (PDogCow)malloc( sizeof(DogCow) );
	if (pSelf)
		{
	int i;
		((PObject)pSelf)->pVtbl = &DogCowVTable;
		for (i=0; i<33; ++i)
			pSelf->DogCowArray[i] = i;
		strcpy( pSelf->DogCowTime, "12 MOON" );
		}
	return pSelf;
}

char *DogCow_GetName( PDogCow pSelf )
{
	return "DogCow - the Maccessory";
}

char *DogCow_FavoriteSaying( PDogCow pSelf )
{
	return "Moof.  Moof.  Moof.";
}

main()
{
PDevo pDevo = Devo_Construct();
PDogCow pDogCow = DogCow_Construct();
	if (pDevo && pDogCow )
		{
	PObject Objects[5];
	int i;
		puts( "Invoking virtual methods on pDevo" );
		puts( (*((PObject)pDevo)->pVtbl->GetName)( (PObject)pDevo ) );
		puts( (*((PObject)pDevo)->pVtbl->FavoriteSaying)( (PObject)pDevo ) );

		puts( "Invoking virtual methods on DogCow with a token pasting macro." );
		puts( Object_Do( pDogCow, GetName ) );
		puts( Object_Do( pDogCow, FavoriteSaying ) );

		puts( "Putting pDevo and pDogCow into a generic collection." );
		Objects[0] = (PObject)pDevo;
		Objects[1] = (PObject)pDogCow;
		Objects[2] = (PObject)pDevo;
		Objects[3] = (PObject)pDevo;
		Objects[4] = (PObject)pDogCow;

		puts( "Enumerating GetName over collection." );
		for (i=0; i<5; ++i)
			puts( Object_Do( Objects[i], GetName ) );

		puts( "Enumerating FavoriteSaying over collection." );
		for (i=0; i<5; ++i)
			puts( Object_Do( Objects[i], FavoriteSaying ) );

		free( pDevo );
		free( pDogCow );
		}
	return 0;
}
