// browsedl.cpp : implementation file
//

#include "stdafx.h"
#include "ole2.h"
#include "ibrowse.h"
#include "browsedl.h"
#include "regkey.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

class COLEInterface : public CObject
{
private:
	CString		m_IID;	// A string representing the interface's global identifier
	CString		m_Name; // A string representing the english name of the interface
public:
	COLEInterface( char *pszIID, char *pszName )
		{
		m_IID = pszIID;
		m_Name = pszName;
		}
	CString* GetIID() { return &m_IID; }
	CString* GetName() { return &m_Name; }
};


/////////////////////////////////////////////////////////////////////////////
// CBrowseDlg dialog

CBrowseDlg::CBrowseDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBrowseDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBrowseDlg)
	//}}AFX_DATA_INIT
}

void CBrowseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBrowseDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBrowseDlg, CDialog)
	//{{AFX_MSG_MAP(CBrowseDlg)
	ON_BN_CLICKED(IDOK, OnClose)
	ON_LBN_SELCHANGE(IDC_OBJECT_LIST, OnSelchangeObjectList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Fill the list of registered interfaces with all the items in the
// 'Interface' section of the registration database.
//
void CBrowseDlg::GetRegisteredInterfaces()
{
CRegKey RegKey( "Interface" );
	for (int i=0; ;++i)
		{
	char *IID = RegKey.QueryName( i );
		if (IID) 
			m_RegInterfaces.AddTail(new COLEInterface( IID, RegKey[i] ));
		else
			break;
		}
}

/////////////////////////////////////////////////////////////////////////////
// Fill the object listbox in the dialog box with the names of registered
// classes from the 'Clsid' section of the registration database.
//
void CBrowseDlg::GetRegisteredClasses()
{
CRegKey RegKey( "CLSID" );
	for (int i=0; ;++i)
		{
	char *ClassId = RegKey.QueryName( i );
		if (ClassId) 
			{
		char Buffer[512];
			wsprintf( Buffer, "%s\t%s", RegKey[i], ClassId );
			m_ObjectLB.AddString( Buffer );
			}
		else
			break;
		}
}


/////////////////////////////////////////////////////////////////////////////
// CBrowseDlg message handlers

/////////////////////////////////////////////////////////////////////////////
// Handle the WM_INITDIALOG message by sub-classing the listboxes and
// setting up the small font.
//
BOOL CBrowseDlg::OnInitDialog()
{
static LOGFONT SmallFont =
{
	8, 0, 0, 0, 400, 0, 0, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS,
	CLIP_DEFAULT_PRECIS, PROOF_QUALITY, DEFAULT_PITCH|FF_SWISS, "Helv"
};

	CDialog::OnInitDialog();
	
	VERIFY(m_Font.CreateFontIndirect( &SmallFont ));
	
	VERIFY(m_ObjectLB.SubclassDlgItem( IDC_OBJECT_LIST, this ));
	m_ObjectLB.SetFont( &m_Font, FALSE );
	m_ObjectLB.SetTabStops( 500 );
	
	VERIFY(m_InterfaceLB.SubclassDlgItem( IDC_INTERFACE_LIST, this ));
	m_InterfaceLB.SetFont( &m_Font, FALSE );
	
	GetDlgItem(IDST_CLASSID)->SetFont(&m_Font, FALSE );
	
	GetRegisteredClasses();
	GetRegisteredInterfaces();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// When the selection in the Object list box changes, fill the interface 
// listbox with all the interfaces supported by the class.
//
void CBrowseDlg::OnSelchangeObjectList()
{
CString Selection( '\0', 512 );
	m_ObjectLB.GetText( m_ObjectLB.GetCurSel(), Selection );
	// The actual class identifier string is stored in the
	// text of the list, separated from the name by a single
	// tab character.
	int TabAt = Selection.Find( '\t' )+1;
	if (TabAt)
		{
	HCURSOR hOldCursor = ::SetCursor( ::LoadCursor( NULL, IDC_WAIT ) );
		SetDlgItemText( IDST_CLASSID, Selection.Mid(TabAt));
		FillInterfaceLB();
		:: SetCursor( hOldCursor );
		}
}
      
/////////////////////////////////////////////////////////////////////////////
// Given the class identifier, attempt to create an instance of the
// class.  Then use QueryInterfacesOf to add all the supported
// interfaces to the listbox.
//
void CBrowseDlg::FillInterfaceLB()
{
char ClassId[256];
CLSID CIID;
	m_InterfaceLB.ResetContent();
	GetDlgItemText( IDST_CLASSID, ClassId, sizeof(ClassId));
HRESULT hResult = CLSIDFromString( ClassId, &CIID);
	if (hResult == NOERROR)
		{
	IUnknown FAR* pIUnknown;
		// Creates an instance of the class identified by CLSID_CPoly
		hResult = CoCreateInstance( CIID, NULL, CLSCTX_SERVER|CLSCTX_INPROC, IID_IUnknown, (void FAR* FAR*)&pIUnknown);
	  	if(	hResult == NOERROR)
   			{                
   			QueryInterfacesOf(pIUnknown);
   			pIUnknown->Release();
   			}
   		else
	   		{
			m_InterfaceLB.AddString( "CoCreateInstance failed." );
   			}
   		}
}
      
/////////////////////////////////////////////////////////////////////////////
// Given a pointer to the IUnknown interface, invoke the QueryInterface
// method to see what interfaces are supported by the object.  For each
// interface that is supported, add the name to the list box.
//
void CBrowseDlg::QueryInterfacesOf(IUnknown FAR* pIUnknown)
{
POSITION Position = m_RegInterfaces.GetHeadPosition();
COLEInterface *pInterface;
	while ( Position && (pInterface = (COLEInterface *)m_RegInterfaces.GetAt(Position)))
		{
	const char * Name = (const char *)(*pInterface->GetName());
	IID InterfaceId;		
		if (NOERROR==IIDFromString( (char*)(const char *)(*pInterface->GetIID()), &InterfaceId))
			{
		IUnknown FAR* pQueriedInterface;
			if (pIUnknown->QueryInterface(InterfaceId, (void **)&pQueriedInterface)==NOERROR)
				{
				m_InterfaceLB.AddString( Name );
				pQueriedInterface->Release();
				}
			}
		pInterface = (COLEInterface *)m_RegInterfaces.GetNext( Position );
		}
	m_InterfaceLB.AddString( "IUnknown" );
}


void CBrowseDlg::OnClose()
{
	// TODO: Add your control notification handler code here
	EndDialog( IDOK );
}
