LISTING 5 - Illustrates RTTI features

#include <iostream.h>
#include <typeinfo.h>

main()
{
    B b;
    D d;
    B *bp = &d;

    if (dynamic_cast<D*>(bp))
        cout << "downcast OK\n";
    else
        cout << "downcast not OK\n";

    cout << "b's type name == "
         << typeid(b).name() << endl;
    cout << "d's type name == "
         << typeid(d).name() << endl;
    cout << "bp's type name == "
         << typeid(bp).name() << endl;
    cout << "b and d are "
         << (typeid(b) == typeid(d)
             ? ""
             : "not ")
         << "the same type" << endl;
    return 0;
}

/* Output:
downcast OK
b's type name == B
d's type name == D
bp's type name == B *
b and d are not the same type
*/
