/* CURRENCY.C - Demonstration application for Currency Formatting. */
/* Written by: R. Scott Guthrie                                    */
/* Requires XLATE functions and translate file entries for         */
/*  "Our Currency", "Alt Currency 1", and "Alt Currency 2"         */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xlate.h"

void main()
{
  char format[80];      /* Constructed format string buffer */

  /* The next two values represent the value of each 'Alt Currency' */
  /* unit to each unit of 'Our Currency'.                           */
  /* These values must be loaded at run time since the conversion   */
  /* rates for currency values is dynamic, but sample data is       */
  /* directly assigned for demonstration purposes here.             */
  float AltCurrency1 = 0.6;
  float AltCurrency2 = 1.4;

  float Amount = 2.8;   /* Amount of 'Our Currency' to be converted */

  XlateSet("CURRENCY");

  /* Build the format string */
  strcpy(format, "%5.2f ");
  strcat(format, Xlate("Our Currency"));
  strcat(format, " = %5.2f ");
  strcat(format, Xlate("Alt Currency 1"));
  strcat(format, "\n");

  /* Print Our Currency and the value of the Alternate Currency */
  printf(format, Amount, Amount * AltCurrency1);

  /* Again for the second alternate currency... */
  /* Build the format string */
  strcpy(format, "%5.2f ");
  strcat(format, Xlate("Our Currency"));
  strcat(format, " = %5.2f ");
  strcat(format, Xlate("Alt Currency 2"));
  strcat(format, "\n");

  /* Print Our Currency and the value of the Alternate Currency */
  printf(format, Amount, Amount * AltCurrency2);

  /* Free Translate Table memory */
  XlateFree();
}
/* end source file CURRENCY.C */
