/* LANGUAGE.C - Demonstration application for Unspecified Number   */
/*              of Entries.                                        */
/* Written by: R. Scott Guthrie                                    */
/* Requires XLATE functions and translate file entries for         */
/*  "Number of Languages", "Language 1", "Language 2" ... for the  */
/* number of languages specified in "Number of Languages"          */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xlate.h"

void main()
{
  char LanguageString[80];   /* Language string buffer */
  int  LanguageCount;        /* Number of Languages */
  int i;                     /* index variable */

  XlateSet("LANGUAGE");

  /* Get the number of Languages */
  LanguageCount = atoi(Xlate("Number of Languages"));

  /* Display Language list */
  printf("There are %0d Languages.  These are:\n", LanguageCount);
  for(i=1; i<=LanguageCount; i++)
  {
	sprintf(LanguageString, "Language %0d", i);
	printf("%s\n",Xlate(LanguageString));
  }

  /* Free Translate Table memory */
  XlateFree();

}
/* end source file LANGUAGE.C */
