Listing 5 - a template for a queue with element of type T using friend 
classes

//
// queue10.h - a template for a queue class
// using global cell and iterator classes
// as friends of the queue class
//

//
// the "declare" part
//
template <class T>
class queue_cell
    {
    friend class queue<T>;
    friend class queue_iterator<T>;
private:
    queue_cell(const T &, queue_cell<T> *);
    queue_cell *next;
    T element;
    };

template <class T>
inline queue_cell<T>::queue_cell(const T &e, queue_cell<T> *p)
    : element(e), next(p)
    {
    }

template <class T>
class queue
    {
public:
    queue();
    ~queue();
    void append(const T &e);
    void clear();
    int remove(T &e);
    friend class queue_iterator<T>;
private:
    queue_cell<T> *first, *last;
    };

template <class T>
class queue_iterator
    {
public:
    queue_iterator(const queue<T> &q);
    T *next();
private:
    queue_cell<T> *pc;
    };

template <class T>
inline queue_iterator<T>::queue_iterator(const queue<T> &q)
    : pc(q.first)
    {
    }

template <class T>
T *queue_iterator<T>::next()
    {
    T *pt = 0;
    if (pc != 0)
        {
        pt = &pc->element;
        pc = pc->next;
        }
    return pt;
    }

//
// the "implement" part
//
template <class T>
inline queue<T>::queue()
    : first(0), last(0)
    {
    }

template <class T>
inline queue<T>::~queue()
    {
    clear();
    }

template <class T>
void queue<T>::append(const T &e)
    {
    queue_cell<T> *p = new queue_cell<T>(e, 0);
    if (first == 0)
        first = p;
    else
        last->next = p;
    last = p;
    }

template <class T>
void queue<T>::clear()
    {
    queue_cell<T> *p;
    while (first != 0)
        {
        p = first;
        first = first->next;
        delete p;
        }
    }

template <class T>
int queue<T>::remove(T &e)
    {
    if (first == 0)
        return 0;
    queue_cell<T> *p = first;
    if ((first = first->next) == 0)
        last = 0;
    e = p->element;
    delete p;
    return 1;
    }

