Listing 1 - a template for a queue with element of type T using nested 
classes

//
// queue9.h - a template for a queue class
// with a nested private cell class
// and a nested public iterator class
//

//
// the "declare" part
//
template <class T>
class queue
    {
private:
    struct cell
        {
        cell *next;
        T element;
        cell(const T &e, cell *p)
            : element(e), next(p) { }
        };
    cell *first, *last;
public:
    queue();
    ~queue();
    void append(const T &e);
    void clear();
    int remove(T &e);
    class iterator;
    friend class iterator;
    class iterator
        {
    public:
        iterator(const queue<T> &q)
            : pc(q.first) { }
        T *next()
            {
            T *pt = 0;
            if (pc != 0)
                {
                pt = &pc->element;
                pc = pc->next;
                }
            return pt;
            }
    private:
        cell *pc;
        };
    };

template <class T>
inline queue<T>::queue()
    : first(0), last(0)
    {
    }

template <class T>
inline queue<T>::~queue()
    {
    clear();
    }

//
// the "implement" part
//
template <class T>
void queue<T>::append(const T &e)
    {
    cell *p = new cell(e, 0);
    if (first == 0)
        first = p;
    else
        last->next = p;
    last = p;
    }

template <class T>
void queue<T>::clear()
    {
    cell *p;
    while (first != 0)
        {
        p = first;
        first = first->next;
        delete p;
        }
    }

template <class T>
int queue<T>::remove(T &e)
    {
    if (first == 0)
        return 0;
    cell *p = first;
    if ((first = first->next) == 0)
        last = 0;
    e = p->element;
    delete p;
    return 1;
    }

