Listing 2 - a program for testing queue<T> instantiated as queue<str>

//
// strtst9.cpp - test queue<T> using str elements
//

#include <iostream.h>

#include "queue9.h"
#include "showheap.h"
#include "str.h"

ostream &operator<<(ostream &os, queue<str> &q)
    {
    str *ps;
    queue<str>::iterator sqi(q);
    while ((ps = sqi.next()) != 0)
            os << ' ' << *ps;
    return os;
    }

#define DIM(a) (sizeof(a)/sizeof(a[0]))

void test()
    {
    char c;
    size_t qn;
    str qe;
    queue<str> q[4];
    while (cin >> c)
        {
        showheap();
        if (c == 'q')
            break;
        if (c == 'a')
            {
            cin >> qn >> qe;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else
                q[qn].append(qe);
            }
        else if (c == 'c')
            {
            cin >> qn;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else
                q[qn].clear();
            }
        else if (c == 'r')
            {
            cin >> qn;
            if (qn >= DIM(q))
                cout << "no such queue\n";
            else if (q[qn].remove(qe))
                cout << "removed " << qe << '\n';
            else
                cout << "q[" << qn << "] is empty\n";
            }
        else
            continue;
        for (size_t i = 0; i < DIM(q); ++i)
            cout << i << ':' << q[i] << '\n';
        }
    }

int main()
    {
    showheap();
    test();
    showheap();
    return 0;
    }

