/* Listing 3 */
/* EXTR.C */
/*  Copyright 1993 by P.J. LaBrocca
    All rights reserved.
*/
/* The Extraction Module */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sea.h"

void bailout( void )
{
    printf( "\nUsage: archiveName [ -l ]\n" );
    printf( "    archiveName     Extract files.\n" );
    printf( "    archiveName -l  List files.\n" );
    exit( 0 );
}

void main( int argc, char **argv )
{
    FILE *input, *output;
/* size of extraction module */
    long MagicNumber = 10867 ; /* sic */
    int count = 1;
    HEADER header;
    long i;
    int sw;

/* verify user input */    
    if( argc > 2 ) {
        bailout();
    }
    if( argc == 1 )
        ;
    else if( strcmp( argv[1], "-l" ) == 0 )
        sw = 'l';
    else
        bailout();

/* open self-extracting archive */
    if( ( input = fopen( argv[0], "rb" ) ) == NULL ) {
        printf( "error opening %s\n", argv[0] );
        exit( 0 );
    } /* if( ( input = */

/* skip extraction module */
    fseek( input, MagicNumber, SEEK_SET );

    switch( sw ) {
    default:          /* extract contents of archive */
      while( 1 ) {
        fread(&header, sizeof(HEADER), 1, input);
        if(header.filesize == -1L)
            break;
        if((output=fopen(header.filename,"wb"))==NULL){
          printf("error opening %s\n",header.filename);
          exit(0);
        } /* if(( output = */

        printf("Creating %-55s", header.filename);
        for( i = 0; i < header.filesize; ++i ) {
            putc( getc( input ), output );
        } /* for( i = 0; i < */
        printf("Done!\n");
        fclose( output );
        ++count;
      } /* while(  ) */
      break;
    case 'l':         /* list contents of archive */
      while( 1 ) {
          fread(&header, sizeof(HEADER), 1, input);
          if( header.filesize == -1L )
              break;
          printf(" %-15s%9ld\n", header.filename,
                                     header.filesize);
/* Skip file contents. */
          fseek( input, header.filesize, SEEK_CUR );
          ++count;
      } /* while(  ) */
      break;
    } /* switch */
        
    fclose( input );
} /* main */

/* End of File */
