Listing 4 - a declaration in an inner scope hides all functions with the 
same name in an outer scope

#include <stdio.h>

void put(char c, FILE *stream);
void put(const char *s, FILE *stream);

class File
    {
    FILE *f;
public:
    File(FILE *ff) : f(ff) { }
    void put(const char *s);
    };

void File::put(const char *s)
    {
    ::put(s, f);    // needs :: to access outer scope
    }

int main()
    {
    File f(stdout);
    f.put("hello, world\n");
    return 0;
    }
