/* BAZ.H
 * Contributed to Public Domain 9/93
 * by Thad Smith, Boulder Co.
 */

/* External interfaces */
typedef enum {          /* decoder return status:   */
   DECR_OK,             /* normal return            */
   DECR_NO_ENDMARK,     /* no end marker on data    */
   DECR_INVALID_DATA,   /* invalid input data       */
   DECR_CRC_ERR,        /* CRC error                */
   DECR_END             /* decoding complete        */
}  decode_stat;

/* Output function type */
typedef int outf_t (const char *out, size_t len);

int 
ebaz_init (           /* Initialize encoder       */
   int p_width,         /* width of output lines    */
   outf_t * p_outfunc); /* function taking output   */

int 
ebaz_data (           /* Encode data block        */
   const unsigned char *data, /* input data         */
   size_t len);         /* length of data or 0=end  */

int 
dbaz_init (           /* Initialize encoder       */
   outf_t * p_outfunc); /* function taking output   */

decode_stat 
dbaz_data (           /* Decode data block        */
   const unsigned char *data, /* input data         */
   size_t len);         /* length of data or 0=end  */

/** Return number of characters in internal buffer.
 * This can be used after DECR_END status is returned
 * to determine the number of unused characters given
 * to the decoder. */
size_t      dbaz_excess_chars (void);

void 
encode_9_to_11 (        /* Basic block encoder      */
   char out[11], const unsigned char in[9]);
int             /* return: 0=OK, 1= invalid input */
decode_11_to_9 (        /* Basic block decoder      */
   unsigned char out[9], const char in[11]);

/* End of File */ 

