/** CRC16G.C
 * 
 * Adapted from CRC-16F.C, a public domain routine
 * in Bob Stout's Snippets file collection.
 * Adaptations donated to public domain.
 * 
 * Call initcrctab() to initialize table.
 */
#include "crc16.h"

unsigned short crctab[1 << 8];
static int  initialized = 0;

#define P 0x1021          /* CRC polynomial */

unsigned short
updcrc(unsigned short crc,      /* prev CRC */
       const unsigned char *cp, /* new data */
       unsigned int cnt)        /* # bytes  */
{                       
   while (cnt--)
      crc = UPDATE_CRC1(*cp++, crc);
   return (crc & CRCMASK);
}

void initcrctab(void) {
   unsigned int b, v;
   int         i;
   if (initialized)
      return;

   for (b = 0; b <= (1 << 8) - 1; ++b) {
      for (v = b << (CRCW - 8), i = 8; --i >= 0;)
         v = v & 0x8000 ? (v << 1) ^ P : v << 1;
      crctab[b] = v;
   }
   initialized = 1;
}

/* End of File */ 

