LISTING 8 - Removes extraneous loop controls from Listing 2

/* hi-lo2.c:    Removes extraneous boolean flags */

#include <stdio.h>
#include <ctype.h>

main()
{
    puts("Think of a number between 1 and 100.");
    puts("If you don't cheat, I'll figure it out");
    puts("in seven guesses or less!\n");

    for (;;)    /* An idiom for REPEAT FOREVER */
    {
        int lo = 1, hi = 100;
        int guess;
        char response;

        /* Play the Game */
        while (lo <= hi)
        {
            /* Get response */
            guess = (lo + hi) / 2;
            printf("Is it %d (L/H/Y): ",guess);
            fflush(stdout);
            scanf("%c%*c",&response);
            response = toupper(response);

            /* Narrow the search range */
            if (response == 'L')
                lo = guess + 1;
            else if (response == 'H')
                hi = guess - 1;
            else if (response != 'Y')
                puts("What? Try again...");
            else
                break;
        }

        /* Print results */
        if (lo > hi)
            puts("You cheated!");
        else
        {
            printf("Your number was %d\n",guess);
            puts("What fun!");
        }

        printf("Wanna play again? ");
        fflush(stdout);
        scanf("%c%*c",&response);
        if (toupper(response) != 'Y')
            break;
    }
    return 0;
}

