LISTING 13 - A skeleton for a command interpreter - illustrates
branching out of a signal handler

/* shell.c: A skeleton for a command interpreter */

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
/* etc. */

jmp_buf restart;

void ctrlc(int sig);

main()
{
    /* Install signal handler */
    signal(SIGINT,ctrlc);

    /* Return here on keyboard interrupt */
    setjmp(restart);

    /* Do any other initialization here... */

    for (;;)
    {
        int command_code;
        /* etc... */

        /* Read and parse command here... */

        /* Execute internal command here */
        switch(command_code)
        {
            case 'Q':
                return 0;   /* quit */

            /*  Lots of cases follow... */
        }
    }
}

void ctrlc(int sig)
{
    /* Reinstall handler */
    signal(sig,ctrlc);

    /* Jump back to command line */
    longjmp(restart,1);
    return;
}

