/* _Expf function */
#define _INCLUDE_XOPEN_SOURCE
#include <math.h>
#include "xmath.h"

#define hugexp (double)HUGE_EXP

int _Expf(double *px)
{
  /* Compute e^(*px), x finite */

  double y, g, even;
  int xexp, inc;
  const static double round[] = {.5, -.5};
#if 0
/* Works OK but slow on many machines */
  xexp = *px * M_LOG2E + round[*px < 0];
#else
  /* VAX requires -(((short *)px)[1]>>15) */
  xexp = *px * M_LOG2E + round[((unsigned int *) px)[_D0] >> 31];
#endif
  g = *px - xexp * M_LN2;
  g *= (y = g * g) + 60.09114349;
  even = y * 12.01517514 + 120.18228722;
  *px = (even + g) / (even - g);
  /* Limit exponent to wide enough range to cause over/underflow upon
   * conversion to float without getting into double over/underflow */
  inc = g > 0;
  if (xexp > DBL_MAX_EXP - inc) xexp = DBL_MAX_EXP - inc;
  if (xexp < DBL_MIN_EXP - inc) xexp = DBL_MIN_EXP - inc;
  ((unsigned long *) px)[_D0] += xexp << _DOFF;	/* scale by 2^xexp */
  return xexp + inc;		/* exponent = ceil(log2(*px)) */
}
