/* math.h standard header */
#ifndef _MATH
#define _MATH
		/* macros */
/* some constants from traditional <math.h> and XOPEN */
#  define M_E		2.7182818284590452354
#  define M_LOG2E	1.4426950408889634074
#  define M_LOG10E	0.43429448190325182765
#  define M_LN2		0.69314718055994530942
#  define M_LN10	2.30258509299404568402
#  define M_PI		3.14159265358979323846
#  define M_PI_2	1.57079632679489661923
#  define M_PI_4	0.78539816339744830962
#  define M_1_PI	0.31830988618379067154
#  define M_2_PI	0.63661977236758134308
#  define M_2_SQRTPI	1.12837916709551257390
#  define M_SQRT2	1.41421356237309504880
#  define M_SQRT1_2	0.70710678118654752440
		/* type definitions */
typedef const union {
	unsigned long _W[2];
	double _D;
	} _Dconst;
		/* declarations */
double acos(double);
double asin(double);
double atan(double);
double atan2(double, double);
double ceil(double);
double cos(double);
double cosh(double);
double exp(double);
double fabs(double);
double floor(double);
double fmod(double, double);
double frexp(double, int *);
double ldexp(double, int);
double log(double);
double log10(double);
double modf(double, double *);
double pow(double, double);
double sin(double);
double sinh(double);
double sqrt(double);
double tan(double);
double tanh(double);
double _Asin(double, int);
double _Log(double, int);
double _Sin(double, unsigned int);
extern _Dconst _Hugeval;
		/* macro overrides */
#define acos(x)	_Asin(x, 1)
#define asin(x)	_Asin(x, 0)
#define atan(x) atan2(x,1.)
#define cos(x)	_Sin(x, 1)
#define log10(x) log(x)*M_LOG10E
#define sin(x)	_Sin(x, 0)
float acosf(float);
float asinf(float);
float atanf(float);
float atan2f(float, float);
float ceilf(float);
float cosf(float);
float coshf(float);
float expf(float);
float fabsf(float);
float floorf(float);
float fmodf(float, float);
float frexpf(float, int *);
float ldexpf(float, int);
float logf(float);
float log10f(float);
float modff(float, float *);
float powf(float, float);
float sinf(float);
float sinhf(float);
float sqrtf(float);
float tanf(float);
float tanhf(float);
typedef struct{float s;float c;float t;}_scos;
_scos _Sinf(double);
double _Logf(double);
#define atanf(x) atan2f(x,1.f)
#define cosf(x)	_Sinf(x).c
#define frexpf(x,p) (float)frexp(x,p)
#define ldexpf(x,y) (float)ldexp(x,y)
#define logf(x)	(float)_Logf(x)
#define log10f(x) (float)(M_LOG10E*_Logf(x))
#define sinf(x)	_Sinf(x).s
#define tanf(x)	_Sinf(x).t
/* following macros are unsafe when x,y have side effects */
#define acosf(x) atan2f((float)sqrt((1-(double)(x)*(x))),x)
#define asinf(x) atan2f(x,(float)sqrt((1-(double)(x)*(x))))
#define ceilf(x) (float)(long int)((x)>0?1-.25*FLT_EPSILON+(x):(x))
#define fabsf(x) ((x)<0?-(x):(x))   /* not if compiler has own code */
#define floorf(x) (float)(long int)((x)<0?.25*FLT_EPSILON-1+(x):(x))
#define fmodf(x,y) (float)((x)-(long int)((x)/(y))*(double)(y))
#define modff(x,p) ((x)-(*p=(long int)(x)))
#endif
