Listing 10 - A test program for a generic queue of void * used as a 
queue of int

//
// inttst3.cpp - test genq3
//

#include <iostream.h>

#include "genq3.h"
#include "showheap.h"

#define DIM(a) (sizeof(a)/sizeof(a[0]))

void print_int(void *e)
	{
	cout << " " << *(int *)e;
	}

void test()
	{
	char c;
	size_t qn;
	int qe;
	int *pqe;
	void *pv;
	genq q[4];
	while (cin >> c)
		{
		showheap();
		if (c == 'q')
			break;
		if (c == 'a')
			{
			cin >> qn >> qe;
			if (qn >= DIM(q))
				cout << "no such queue\n";
			else
				q[qn].append(new int(qe));
			}
		else if (c == 'c')
			{
			cin >> qn;
			if (qn >= DIM(q))
				cout << "no such queue\n";
			else
				q[qn].clear();
			}
		else if (c == 'r')
			{
			cin >> qn;
			if (qn >= DIM(q))
				cout << "no such queue\n";
			else if (q[qn].remove(pv))
				{
				pqe = (int *)pv;
				cout << "removed " << *pqe << '\n';
				delete pqe;
				}
			else
				cout << "q[" << qn << "] is empty\n";
			}
		else
			continue;
		for (size_t i = 0; i < DIM(q); ++i)
			{
			cout << i << ':';
			q[i].apply(print_int);
			cout << "\n";
			}
		}
	}

int main()
	{
	showheap();
	test();
	showheap();
	return 0;
	}

