Listing 7 - a heap monitoring function

//
// showheap.cpp - display the contents of the heap
//

#if defined(__TURBOC__)
#include <alloc.h>
#include <stdio.h>

void showheap()
	{
	static int first = 1;
	static void *p = 0;
	char s[40];
	struct heapinfo hi;
	if (heapcheck() == _HEAPOK)
		{
		hi.ptr = p;
		cout << "   addr   size   status\n";
		while (heapwalk(&hi) == _HEAPOK)
			{
			if (first)
				p = hi.ptr;
			sprintf(s, "%7p%7lu   %s\n",
				hi.ptr, (unsigned long)hi.size,
				hi.in_use ? "used" : "free");
			cout << s;
			}
		first = 0;
		}
	else if (heapcheck() == _HEAPCORRUPT)
		cout << "heap is corrupt!\n";
	}

#elif defined(_MSC_VER) || defined(__WATCOMC__)
#include <malloc.h>
#include <stdio.h>

void showheap()
	{
	static int first = 1;
#if defined(_MSC_VER)
	static int far *p = 0;
#elif defined(__WATCOMC__)
	static void far *p = 0;
#endif
	char s[40];
	_HEAPINFO hi;
	if (_heapchk() == _HEAPOK)
		{
		hi._pentry = p;
		cout << "   addr   size   status\n";
		while (_heapwalk(&hi) == _HEAPOK)
			{
			if (first)
				p = hi._pentry;
			sprintf(s, "%7Fp%7lu   %s\n",
				hi._pentry, (unsigned long)hi._size,
				hi._useflag ? "used" : "free");
			cout << s;
			}
		first = 0;
		}
	else if (_heapchk() != _HEAPEND)
		cout << "heap is corrupt!\n";
	}

#else

void showheap() { }

#endif

