Listing 3 - class definitions for a queue of str using a non-nested cell 
type

//
// strq1.h - a queue of str (interface)
//

#include <iostream.h>

#include "str.h"

class strq_cell
	{
	friend class strq;
private:
	strq_cell(const str &e, strq_cell *p);
	strq_cell *next;
	str element;
	};

class strq
	{
public:
	strq();
	~strq();
	void append(const str &e);
	void clear();
	void print(ostream &os) const;
	int remove(str &e);
private:
	strq_cell *first, *last;
	};

inline strq_cell::strq_cell(const str &e, strq_cell *p)
	: element(e), next(p)
	{
	}

inline strq::strq() : first(0), last(0)
	{
	}

inline strq::~strq()
	{
	clear();
	}

