/* ARCH.C
*/

#include <io51.h>

#pragma language=extended

#define TMOD0 0x01
#define TMOD1 0x20

#define SERIAL_MODE1 0x40
#define RECEIVE_ENABLE 0x10
#define DISCARD_FRAME_ERROR 0x20

#define T0_COUNT 1250
#define T0_LOAD ((unsigned)(0x10000L - T0_COUNT))

#define BAUD_RATE 0xfc

/* Note:  Keyword "data" tells compiler to put the
          following in internal RAM
*/
data int millisecond_counter;
bit first_time;

interrupt [0x0B] using [1] void my_isr(void)
{
    P1.7 = 1;  /* Signal start of ISR */

    /* Load Timer 0 starting count */
    TR0 = 0;   /* disable Timer 0 counting */

    TH0 = T0_LOAD >> 8;    /* Load high byte */
    TL0 = T0_LOAD & 0xff;  /* Load low byte  */

    TR0 = 1;  /* Re-enable Timer 0 counting */


    ++millisecond_counter;

    P1.7 = 0;  /* Signal end of ISR */
}

char read_char()
{
    while(!RI)
        ;
    RI = 0;
    return(SBUF);
}

void write_char(char c)
{
    while(!(TI||first_time))
        ;
    first_time = 0;
    TI = 0;
    SBUF = c;
}

void setup(void)
{
    /* prepare Timer 0, Timer 1 and serial port */
    first_time = 1;
    TH1 = BAUD_RATE;
    TMOD = TMOD0 | TMOD1;
    SCON = SERIAL_MODE1 | RECEIVE_ENABLE
           | DISCARD_FRAME_ERROR;
    TR1 = 1;  /* Turn on Timer 1 */
    TR0 = 1;  /* Turn on Timer 0 */

    ET0 = 1;  /* Enable Timer 0 interrupts */
    EA = 1;   /* Enable All enabled interrupts. */
}

void main()
{
    setup();

    for(;;) {
        write_char(read_char());
    }
}
