
Listing 8: Function Pstatement::parse()

BOOL Pstatement::parse()
{
 BOOL result;
 Token * pTemp;

 pTemp = gpTokenizer->getToken();  // get a new token

 switch (pTemp->tokentype)   // differentiate commands
 {
        .
        .
 case tkif:
       Pif * pMyIf = new Pif;  // create a if parse node
       PARSE(pMyIf)  // call the parse function and clean up
       break;
 case tkcall:
       Pcall * pMyCall = new Pcall;   // create a call parse node
       PARSE(pMyCall)      // call the parse function and clean up
       break;
 case tkcase:
       Pcase * pMyCase = new Pcase;
       PARSE(pMyCase)
       break;
 case tkdialog:
       Pdialog * pMyDialog = new Pdialog;
       PARSE(pMyDialog)
       break;
 case tkfor:
       Pfor * pMyFor = new Pfor;
       PARSE(pMyFor)
       break;
 case tkgoto:
       PgoTo * pMyGoTo = new PgoTo;
       PARSE(pMyGoTo)
       break;
 case tkgosub:
       PgoSub * pMyGoSub = new PgoSub;
       PARSE(pMyGoSub)
       break;
        .
        .
 case tkend:
 case tkendif:
 case tkendfor:
 case tkendcase:
 case tkelse:
       result = TRUE;
       break;
 default:result = FALSE;
       gpErrorFile->raise(10);   // gpErrorFile is a class to handle errors
       break;
 } // end of switch

 return result;
}

