
       /*********************************************
       *
       *   file d:\cips\mainsk.c
       *
       *   Functions: This file contains
       *      main
       *
       *   Purpose:
       *      This file contains the main calling
       *      routine that calls the erosion, dilation,
       *      outline, and skeleton functions.
       *
       *   External Calls:
       *      gin.c - get_image_name
       *      numcvrt.c - get_integer
       *                  int_convert
       *      tiff.c - read_tiff_header
       *      ed.c - erosion
       *             dilation
       *             mask_erosion
       *             mask_dilation
       *             interior_outline
       *             exterior_outline
       *             opening
       *             closing
       *      skeleton.c - thinning
       *                   skeleton
       *                   dilate_not_join
       *                   special_opening
       *                   special_closing
       *                   edm
       *                   mat
       *
       *   Modifications:
       *      7 March 1993 - created
       *
       ***********************************************/

#include "cips.h"



short the_image[ROWS][COLS];
short out_image[ROWS][COLS];

main(argc, argv)
   int argc;
   char *argv[];
{

   char     name[80], name2[80], name3[80], type[80];
   int      count, i, j,
            il, ie, ll, le,
            length, lw, mask_type, number,
            threshold, width;
   short    value;
   struct   tiff_header_struct image_header;

   my_clear_text_screen();

       /*********************************************
       *
       *   Interpret the command line parameters.
       *
       **********************************************/

   if(argc < 5){
    printf(
    "\n\nNot enough parameters:"
     "\n"
     "\n usage: mainsk in-file out-file type value"
     " [threshold-or-mask-type] [number]"
     "\n"
     "\n recall type: EROsion DILation Mask-ERosion"
     "\n              Mask_DIlation INTerior-outline"
     "\n              EXTerior-outline THInning"
     "\n              Dilate-Not-Join OPEning"
     "\n              CLOsing SPecial-Opening"
     "\n              SPecial-Closing"
     "\n              Euclidean-Distance-Measure"
     "\n              Medial-Axis-Transform"
     "\n"
     "\n              [number] needed for opening"
     "\n              and closing"
     "\n");
    exit(0);
   }

   strcpy(name,     argv[1]);
   strcpy(name2,    argv[2]);
   strcpy(type,     argv[3]);
   value     = atoi(argv[4]);
   threshold = atoi(argv[5]);
   mask_type = atoi(argv[5]);
   number    = atoi(argv[6]);

   il = 1;
   ie = 1;
   ll = ROWS+1;
   le = COLS+1;

       /*********************************************
       *
       *   Read the input image header and setup
       *   the looping counters.
       *
       **********************************************/

   read_tiff_header(name, &image_header);

   length = (ROWS-10 + image_header.image_length)/ROWS;
   width  = (COLS-10 + image_header.image_width)/COLS;
   count  = 1;
   lw     = length*width;
   printf("\nlength=%d  width=%d", length, width);

       /*********************************************
       *
       *   Loop over the input images and
       *   apply the desired function.
       *
       **********************************************/

   for(i=0; i<length; i++){
      for(j=0; j<width; j++){
         printf("\nrunning %d of %d", count, lw);
         count++;

            /* thinning */
         if(strncmp("thi", type, 3) == 0){
            thinning(name, name2, the_image, out_image,
                     il+i*ROWS, ie+j*COLS,
                     ll+i*ROWS, le+j*COLS,
                     value, threshold, 0);
         }  /* ends thinning operation */

            /* dilate-not-join */
         if(strncmp("dnj", type, 3) == 0){
            dilate_not_join(name, name2, 
                            the_image, out_image,
                            il+i*ROWS, ie+j*COLS,
                            ll+i*ROWS, le+j*COLS,
                            value, threshold);
         }  /* ends dilate_not_join operation */

            /* erosion */
         if(strncmp("ero", type, 3) == 0){
            erosion(name, name2, the_image, out_image,
                    il+i*ROWS, ie+j*COLS,
                    ll+i*ROWS, le+j*COLS,
                    value, threshold);
         }  /* ends erosion operation */

            /* dilation */
         if(strncmp("dil", type, 3) == 0){
            dilation(name, name2, the_image, out_image,
                     il+i*ROWS, ie+j*COLS,
                     ll+i*ROWS, le+j*COLS,
                     value, threshold);
         }  /* ends dilation operation */

            /* mask_erosion */
         if(strncmp("mer", type, 3) == 0){
            mask_erosion(name, name2, the_image,
                         out_image, il+i*ROWS,
                         ie+j*COLS, ll+i*ROWS,
                         le+j*COLS, value, mask_type);
         }  /* ends mask_erosion operation */

            /* mask_dilation */
         if(strncmp("mdi", type, 3) == 0){
            mask_dilation(name, name2, the_image,
                          out_image, il+i*ROWS,
                          ie+j*COLS, ll+i*ROWS,
                          le+j*COLS, value, mask_type);
         }  /* ends mask_dilation operation */

            /* interior_outline */
         if(strncmp("int", type, 3) == 0){
            interior_outline(name, name2, the_image,
                             out_image, il+i*ROWS,
                             ie+j*COLS, ll+i*ROWS,
                             le+j*COLS, value,
                             mask_type);
         }  /* ends interior_outline operation */

            /* exterior_outline */
         if(strncmp("ext", type, 3) == 0){
            exterior_outline(name, name2, the_image,
                             out_image, il+i*ROWS,
                             ie+j*COLS, ll+i*ROWS,
                             le+j*COLS, value,
                             mask_type);
         }  /* ends exterior_outline operation */

            /* opening */
         if(strncmp("ope", type, 3) == 0){
            opening(name, name2, the_image,
                    out_image, il+i*ROWS,
                    ie+j*COLS, ll+i*ROWS,
                    le+j*COLS, value,
                    mask_type, number);
         }  /* ends opening operation */

            /* closing */
         if(strncmp("clo", type, 3) == 0){
            closing(name, name2, the_image,
                    out_image, il+i*ROWS,
                    ie+j*COLS, ll+i*ROWS,
                    le+j*COLS, value,
                    mask_type, number);
         }  /* ends closing operation */

            /* special opening */
         if(strncmp("spo", type, 3) == 0){
            special_opening(name, name2, the_image,
                            out_image, il+i*ROWS,
                            ie+j*COLS, ll+i*ROWS,
                            le+j*COLS, value,
                            threshold, number);
         }  /* ends special opening operation */

            /* special closing */
         if(strncmp("spc", type, 3) == 0){
            special_closing(name, name2, the_image,
                            out_image, il+i*ROWS,
                            ie+j*COLS, ll+i*ROWS,
                            le+j*COLS, value,
                            mask_type, number);
         }  /* ends special closing operation */

            /* Euclidean Distance Measure */
         if(strncmp("edm", type, 3) == 0){
            edm(name, name2, the_image,
                out_image, il+i*ROWS,
                ie+j*COLS, ll+i*ROWS,
                le+j*COLS, value);
         }  /* ends Euclidean distance mesaure */

            /* medial axis transform */
         if(strncmp("mat", type, 3) == 0){
            mat(name, name2, the_image,
                out_image, il+i*ROWS,
                ie+j*COLS, ll+i*ROWS,
                le+j*COLS, value);
         }  /* ends medial axis transform operation */

      }  /* ends loop over j */
   }  /* ends loop over i */
}  /* ends main  */
