/* Listing 1		Conversion Functions */



/* Shift amount for fixed point/integer conversions. */
#define FixedPointShiftAmount 8


#define FPToInteger( FP )  ( FP >> FixedPointShiftAmount )

#define IntegerToFP( Integer )  ( Integer << FixedPointShiftAmount )


short FPMulFP( short N, short M )  
{
	return (short) ( ( (long) N * (long) M ) >> FixedPointShiftAmount ); 
}

short FPDivFP( short N, short M )
{
	return (short) ( ( (long) N << FixedPointShiftAmount ) / M );
}


