/* Listing 6		Test program  */

/*
	This test driver is meant to be linked with listings 2, 4, and 5,
	and uses the Borland graphics library. Egavga.bgi needs to be 
	in the same directory as the executable
*/


#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>


#define SIN_COLOR 12
#define COS_COLOR 12


typedef short Trig;     /*  describes a 2.14 fixed point number */
typedef short Angle;    /*  describes a 12.4 fixed point number */


extern Trig cosine( Angle angle );
extern Trig sine( Angle angle );

extern void FloatingPointLine( float x1, float y1, float x2, float y2 );
extern void FixedPointLine( short x1, short y1, short x2, short y2 );
extern void IterativeLine( short x1, short y1, short x2, short y2 );

static void DrawAxis( void );
static void Label( const char *pLabel );


void main( void )
{
	int driver = VGA, mode = VGAHI, errorcode;
	Angle angle;
	Trig sin, cos;
	short screenX, screenY;
	short centerX, centerY;


	/* Init graphics */

	initgraph( &driver, &mode, "" );
	if( ( errorcode = graphresult() ) != grOk )
	{
		printf( "Error: %s\n", grapherrormsg( errorcode ) );
		exit( 10 );
	}

	centerX = getmaxx() / 2;
	centerY = getmaxy() / 2;


	/* Draw Sin function */
	clearviewport();
	DrawAxis();
	Label( "Sin" );

	for( angle=0x8000; angle<0x7fff; angle++ )
	{
		/* Get sine value, scale, and convert to integer */
		sin = sine( angle );

		/* scale to screen */
		screenX = angle >> 7;
		screenY = sin >> 7;

		/* plot */
		putpixel( centerX + screenX, centerY + screenY, SIN_COLOR );
	}

	getch();

	/* Draw Cos function */
	clearviewport();
	DrawAxis();
	Label( "Cos" );

	for( angle=0x8000; angle<0x7fff; angle++ )
	{
		/* Get sine value, scale, and convert to integer */
		sin = cosine( angle );

		/* scale to screen */
		screenX = angle >> 7;
		screenY = sin >> 7;

		/* plot */
		putpixel( centerX + screenX, centerY + screenY, SIN_COLOR );
	}

	getch();

	/* Draw Lines */
	clearviewport();
	DrawAxis();
	Label( "Lines" );

	FloatingPointLine( centerX, centerY - 50, centerX + 50, centerY );
	FloatingPointLine( centerX, centerY + 50, centerX + 50, centerY );
	FloatingPointLine( centerX - 50, centerY, centerX, centerY - 50 );
	FloatingPointLine( centerX - 50, centerY, centerX, centerY + 50 );

	FixedPointLine( centerX, centerY - 100, centerX + 100, centerY );
	FixedPointLine( centerX, centerY + 100, centerX + 100, centerY );
	FixedPointLine( centerX - 100, centerY, centerX, centerY - 100 );
	FixedPointLine( centerX - 100, centerY, centerX, centerY + 100 );

	IterativeLine( centerX, centerY - 150, centerX + 150, centerY );
	IterativeLine( centerX, centerY + 150, centerX + 150, centerY );
	IterativeLine( centerX - 150, centerY, centerX, centerY - 150 );
	IterativeLine( centerX - 150, centerY, centerX, centerY + 150 );

	getch();

	/* DeInit */
	closegraph();
}



void DrawAxis( void )
{
	int maxx, maxy;

	/* get screen extents */
	maxx = getmaxx();
	maxy = getmaxy();

	/* Draw Axis */
	line( maxx / 2, 0, maxx / 2, maxy );
	line( 0, maxy / 2, maxx, maxy / 2 );
}


void Label( const char *pLabel )
{
	outtextxy( 5, 5, pLabel );
}

