/*----------------------------------------*
 * hashhmap.cc --
 *    Implementation of the Map<> template
 */
template <class KEY, class VAL>
void Map<KEY, VAL>::CreateKeyVal(
                        const Map<KEY, VAL> & theDict,
                        const KEY &           theKey,
                        KEY *&                keyCopy,
                        VAL *&                newValue)
{
    keyCopy  = new KEY(theKey);
    newValue = new VAL(theDict.default_value);
}


template <class KEY, class VAL>
void Map<KEY, VAL>::DestroyKeyVal(KEY *key, VAL *value)
{
    delete key;
    delete value;
}


template <class KEY, class VAL>
int Map<KEY, VAL>::CmpKeys(const KEY &a, const KEY &b)
{
    return a == b;
}


template <class KEY, class VAL>
Map<KEY, VAL>::Map(
                  unsigned    (*hash)(const KEY &),
                  const VAL & def_val,
                  size_t      dict_size)

  : VPmap(dict_size,
          KeyHashProc(hash),
          KeyCompareEqProc(Map<KEY, VAL>::CmpKeys),
          KeyValCreateProc(Map<KEY, VAL>::CreateKeyVal),
          KeyValDestroyProc(Map<KEY, VAL>::DestroyKeyVal)),

    default_value(def_val) { }
