/* Listing 1 */

struct StrStack  {
    char * itemPtrs[5U];
    unsigned items;
};

void init(struct StrStack * stackPtr)
{
    if (stackPtr)
        stackPtr->items = 0U;
}

int full(struct StrStack * stackPtr)
{
    if (stackPtr && stackPtr->items < 5U)
        return 0;
    return 1;
}

int push(struct StrStack * stackPtr, char * itemPtr)
{
    if (!full(stackPtr) && itemPtr)  {
        stackPtr->itemPtrs[stackPtr->items++]
            = itemPtr;
        return 1;
    }
    return 0;
}

char * top(struct StrStack * stackPtr)
{
    if (stackPtr && stackPtr->items)
        return stackPtr->itemPtrs[stackPtr->items-1];
    return (char *) 0;
}

char * pop(struct StrStack * stackPtr)
{
    if (stackPtr && stackPtr->items)
        return stackPtr->itemPtrs[--stackPtr->items];
    return (char *) 0;
}

#include <stdio.h>

main()
{
    struct StrStack ToDo;

    init(&ToDo);
    (void) push(&ToDo,"wash car");
    (void) push(&ToDo,"cut grass");
    (void) push(&ToDo,"buy groceries");
    (void) push(&ToDo,"cash paycheck");
    while (top(&ToDo))
        (void) printf("%s\n",pop(&ToDo));
    return 0;
}
