Listing 1
**************************************************
/*  aspeed.c   array vs pointer speed test  */
#include <stdio.h>
#include <time.h>   /* gettime() */

#define  SIZE 1000
#define  REPS 1000

void zerobyincrement(double array[], int howmany);
void zerobydecrement(double array[], int howmany);
void zerobypointer(double array[], int howmany);
double fetchtime( void);

void main()
    {
    double darray[SIZE];
    int i;
    double t0, t1;
    printf("incrementing index...\n");
    t0 = fetchtime();
    for (i=0; i<REPS; i++)
      zerobyincrement(darray, SIZE);
    t1 = fetchtime();
    printf("time... %9.2lf \n", (t1-t0) / CLOCKS_PER_SEC);
    printf("decrementing index...\n");
    t0 = fetchtime();
    for (i=0; i<REPS; i++)
      zerobydecrement(darray, SIZE);
    t1 = fetchtime();
    printf("time... %9.2lf \n", (t1-t0) / CLOCKS_PER_SEC);
    printf("marching pointer... \n");
    t0 = fetchtime();
    for (i=0; i<REPS; i++)
      zerobypointer(darray, SIZE);
    t1 = fetchtime();
    printf("time... %9.2lf \n", (t1-t0) / CLOCKS_PER_SEC);
    }

void zerobyincrement(double array[], int howmany)
    {
    int i;
    for (i=0; i<howmany; i++)
      array[i] = 0.0;
    }

void zerobydecrement(double array[], int howmany)
    {
    int i;
    for (i=howmany-1; i>=0; i--)
      array[i] = 0.0;
    }

void zerobypointer(double array[], int howmany)
    {
    while (howmany--)
      *array++ = 0.0;
    }

double fetchtime( void )
    {
    return (double) clock();
    }
