------------- Listing 2: The file iostream.c ------------------


// iostream -- ios::Init members, standard streams
#include <iostream>
#include <new>
#include <stdio.h>

        // object declarations
int ios::Init::_Init_cnt = -1;
static filebuf fin(ios::_Noinit);
static filebuf fout(ios::_Noinit);
static filebuf ferr(ios::_Noinit);
istream cin(ios::_Noinit);
ostream cout(ios::_Noinit);
ostream cerr(ios::_Noinit);
ostream clog(ios::_Noinit);

ios::Init::Init()
    {       // initialize standard streams first time
    if (0 <= _Init_cnt)
        ++_Init_cnt;
    else
        {       // initialize standard streams
        new (&fin) filebuf(stdin);
        new (&cin) istream(&fin);
        cin.tie(&cout);
        new (&fout) filebuf(stdout);
        new (&cout) ostream(&fout);
        new (&ferr) filebuf(stderr);
        new (&cerr) ostream(&ferr);
        cerr.tie(&cout);
        cerr.setf(ios::unitbuf);
        new (&clog) ostream(&ferr);
        clog.tie(&cout);
        _Init_cnt = 1;
        }
    }

ios::Init::~Init()
    {       // flush standard streams last time
    if (--_Init_cnt == 0)
        {       // flush standard streams
        cout.flush();
        cerr.flush();
        clog.flush();
        }
    }

