// tdnorm.hpp: TableDataNormalize class (LISTING 2)
#ifndef TDNORM_HPP
#define TDNORM_HPP
#include "tbldata.hpp"

// (Note that cellType class must have SetValue() and
// GetValue() methods, and a copy constructor.)
template <class cellType> class TableDataNormalize:
        public TableData<cellType>
{
public:
    TableDataNormalize (TableData<cellType> *const
            prev): TableData<cellType> (prev)
    { }

    virtual const cellType GetCell (const int row,
            const int col)
    {
        assert (PrevTD != 0);
        cellType cell (PrevTD->GetCell (row, col));
        cell.SetValue ( cell.GetValue() /
                (PrevTD->GetCell (0, col)).GetValue());
        return (cell);
    }

    virtual void PutCell (const int row, const int col,
            const cellType &value)
    {
        assert (PrevTD != 0);
        cellType cell (value);
        cell.SetValue ( cell.GetValue() *
                (PrevTD->GetCell (0, col)).GetValue());
        PrevTD->PutCell (row, col, cell);
    }
};
#endif
