LISTING 13 - Adds a stream inserter to the Date class
implementation
// date5.cpp

#include <iostream.h>
#include "date3.h"

const char * Date::month_text[13] =
    {"Bad month", "January", "February", "March", "April",
     "May", "June", "July", "August", "September",
     "October", "November", "December"};

Date::Date(int m, int d, int y) : month(m), day(d), year(y)
{}

ostream & operator<<(ostream & os, const Date &d)
{
    os << Date::month_text[d.month]
       << ' ' << d.day
       << ", " << d.year;
    return os;
}

int Date::compare(const Date & dp2) const
{
    int result = year - dp2.year;
    if (result == 0)
        result = month - dp2.month;
    if (result == 0)
        result = day - dp2.day;
    return result;
}

