#undef GLOBALS
#include "winjes.h"
/*  
    Routine:    MainWndProc
    Called By:  Windows
    Usage:      This is the window procedure for the main window
*/

long FAR PASCAL MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
             
            BOOL            rc;
            char            szName[MAXNAME+1];
            FARPROC         lpProc;
            HDC             hDC;
            HMENU           hMenu;
            int             n;
            int             len;
            int             s;
            PAINTSTRUCT     ps;
            POINT           ptClick;
            RECT            rect;
    struct  hostent FAR     *hp;
    struct  sockaddr_in     sin;
            WORD            wVer;
            WSADATA         wsData;
    switch (message) 
    {                      
      case WM_CREATE:
        wVer = 0x101;   /* version 1.1 */
        rc = WSAStartup(wVer, (LPWSADATA)&wsData);
        sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
        gethostname(szName, MAXNAME);
        hp = gethostbyname((LPSTR)szName);
        if (hp == NULL)
          lstrcpy(szMsg, (LPSTR)"error");
        else
        {
          sin.sin_family = AF_INET;
          sin.sin_port   = htons(MYPORT);
          _fmemcpy((struct sockaddr_in FAR *)&sin.sin_addr, (struct hostent FAR *)hp->h_addr, hp->h_length);
          n = bind(sock, (struct sockaddr FAR *)&sin, sizeof(sin));
          if (n < 0)
            wsprintf((LPSTR)szMsg, (LPSTR)"bind: %d", n);
          else
          {
            WSAAsyncSelect(sock, hWnd, WM_SOCKET, FD_READ | FD_CONNECT | FD_CLOSE);    
            lstrcpy(szMsg, (LPSTR)"ready");
          }
        }
        InvalidateRect(hWnd, NULL, TRUE);
/*
add Tell... to the system menu (so we can get to it even when minimized)
*/        
        hMenu = GetSystemMenu(hWnd, FALSE);
        InsertMenu(hMenu, 0, MF_BYPOSITION, IDM_SEND, (LPSTR)"&Sub...");
        InsertMenu(hMenu, 1, MF_BYPOSITION | MF_SEPARATOR, (UINT)-1, (LPSTR)"");
        break;              
        
      case WM_SOCKET:
        switch (LOWORD(lParam))
        {
          case FD_READ:       // new data/receive queue full                               
            len = sizeof(sin);
            n = recvfrom(sock, (LPSTR)(Message far *)&InMessage, sizeof(Message), 0, (struct sockaddr FAR *)&sin, (int FAR *)&len);
            if (n < 0)
              wsprintf(szMsg, (LPSTR)"err: %d", n);
            else
            {
              if (!lstrcmpi((LPSTR)InMessage.szCommand, (LPSTR)"reboot"))
                ExitWindows(EW_REBOOTSYSTEM, 0);
              if (n = WinExec((LPCSTR)InMessage.szCommand, SW_NORMAL) < 32)
                wsprintf(szMsg, (LPSTR)"rc = %d", n);
              else
                lstrcpy(szMsg, (LPSTR)"command");
            }
            break;

          case FD_CLOSE:       // connection closed
            lstrcpy(szMsg, (LPSTR)"closed");
            break;

          case FD_CONNECT:       // connection request
            lstrcpy(szMsg, (LPSTR)"connect");
            break;            
        }
        InvalidateRect(hWnd, NULL, TRUE);
        break;
        
      case WM_KEYDOWN:
        if (wParam == VK_HOME)
          PostMessage(hWnd, WM_RBUTTONDOWN, (WPARAM)0, MAKELPARAM(0, 0));
        break;
        
      case WM_RBUTTONDOWN:
        hMenu = CreatePopupMenu();
        AppendMenu(hMenu, MF_STRING,    IDM_SEND,  (LPSTR)"&Sub...");
        AppendMenu(hMenu, MF_SEPARATOR, (UINT)-1,  (LPSTR)"");
        AppendMenu(hMenu, MF_STRING,    IDM_ABOUT, (LPSTR)"&About");
        ptClick = MAKEPOINT(lParam);
        ClientToScreen(hWnd, &ptClick);                                
        TrackPopupMenu(hMenu, TPM_LEFTALIGN, ptClick.x, ptClick.y, 0, hWnd, NULL);
        InvalidateRect(hWnd, NULL, TRUE);                      
        DestroyMenu(hMenu);
        break;
        
      case WM_COMMAND:
        switch(wParam)
        {
          case IDM_SEND:                            
            lpProc = MakeProcInstance(HostProc, hInst);
            rc = DialogBox(hInst, (LPSTR)"Command", hWnd, lpProc);
            FreeProcInstance(lpProc);
            if (!rc)
              break;            
            s = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
            hp = gethostbyname((LPSTR)OutMessage.szHostName);    
            if (hp == NULL)
            {
               lstrcpy(szMsg, (LPSTR)"Invalid Host");
               closesocket(s);
            }
            else
            {
              sin.sin_family = AF_INET;
              sin.sin_port   =  htons(MYPORT); 
              _fmemcpy((struct sockaddr_in FAR *)&sin.sin_addr, (struct hostent FAR *)hp->h_addr, hp->h_length);
              gethostname((LPSTR)OutMessage.szHostName, MAXHOST-1);
              sendto(s, (LPSTR)(Message far *)&OutMessage, sizeof(Message), 0, (struct sockaddr FAR *)&sin, sizeof(sin));
              closesocket(s);
              lstrcpy((LPSTR)szMsg, (LPSTR)"outgoing");
            }
            InvalidateRect(hWnd, NULL, TRUE);
            break;

          case IDM_ABOUT:
            lpProc = MakeProcInstance(AboutProc, hInst);
            rc = DialogBox(hInst, (LPSTR)"About", hWnd, lpProc);
            FreeProcInstance(lpProc);
            break;
        }
        break;
        
      case WM_SYSCOMMAND:
        switch(wParam)
        {
          case IDM_SEND:                            
            PostMessage(hWnd, WM_COMMAND, IDM_SEND, 0L);
            break;
            
          default:                          
            return (DefWindowProc(hWnd, message, wParam, lParam));
            break;
      }
      break;
      
      case WM_PAINT:
        hDC = BeginPaint(hWnd, &ps);
        GetClientRect(hWnd, &rect);
        DrawText(hDC, (LPSTR)szMsg, -1, &rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER);
        EndPaint(hWnd, &ps);
        break;
        
      case WM_CLOSE:
        DestroyWindow(hWnd);
        break;
        
      case WM_DESTROY:                  
        closesocket(sock);
        WSACleanup();
        PostQuitMessage(0);
        break;

      default:                          
        return (DefWindowProc(hWnd, message, wParam, lParam));
        break;
    }

    return FALSE;
}
 
