
/*
pager.c - File Browser and Downloader
command line for compile:  cc pager.c -o pager -lcurses
Original platforms: Interactive Unix, XENIX, PC-MSDOS
Currently used platform: SCO Unix 3.2.
Special version for SysAdmin Magazine.
To permit pager to use C-Kermit from Columbia Univ., uncomment the
#define CKERMIT statement below.
*/

#ident "@(#) PAGER  12/14/93  File Browser and Downloader, Fred Lenk. "

#include <curses.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <malloc.h>
#include <memory.h>

#define TAB 9
#define LF 10
#define CR 13
#define FF 12
#define ESC 27
#define MAXCOLS 79
#define MAXLEN 212 /*lines can have 210 cols + NewLine + NULL char*/
/*#define CKERMIT*/

/* provide for 60,000 lines of text.  If all lines were 132 cols, would*/
/* be 7.92MB. Some environments may be able to kick MAXLINES up significantly.*/

/*#define MAXLINES 100000*/
#define MAXLINES 60000

int MAXROWS; /*used to hold max lines on screen*/

FILE *filein,*fileout;
int x,y; /* the lowest cartesian value is 1 */
static char pagerversion[]="PAGER  v.12/14/93 fl\n";
/*over80cols warns printing user to set printer to small font*/
int over80cols=FALSE; /*ifwe have lines with more than 80 cols, set TRUE.*/


main(argc,argv)
int argc;
char *argv[];
{
    char filein_nm[60],fileout_nm[60],dos_nm[60],line1[255],srchstr[80];
    char cmdline[80],haflin[80];
    char *pline[MAXLINES];
	/*char *tempfile_nm;*/
	char tempfile_nm[50];
    int c;
    unsigned long int maxlinelen=MAXLEN;
    unsigned long int linecounter=0;
    /*lastopline: last line that can be placed at top of screen*/
    /*helps to figure out how to display the very last screen.*/
    unsigned long int lastopline;
    /*done flag used to exit program, disp flag means we need to redisplay */
    /*screen, srch flag means we found the search string, shiftscr var used*/
    /*to remember which of 3 shifted screens we are in.*/
    int done=0,disp,srch,shiftscr=0;
    unsigned i,j;
    /*current is always top screen line, mbegin & mend mark a special area in*/
    /*document, last is the last line read into memory.*/
    long int current, mbegin, mend, last;
    int logiclin;/* tracks increment down screen from 'current' (cursor ctrl)*/
    /*case_yn is for case sensitive searches yes/no choice*/
    int key,case_yn;
    unsigned long int fil_size;
    /*statbuff used to get info about a file*/
    struct stat statbuff;
    int tabs[16];


    for(i=1;i<=16;i++) tabs[i]=i*8; /*init the tabs array with stops*/
    /*do terminfo initialization*/
    initscr();
    cbreak();
    noecho();
    nonl();
    keypad(stdscr,TRUE);
    MAXROWS=LINES-1; /*LINES provided by curses initialization*/

    clearscr();

    printw("%s",pagerversion);
    refresh();

    /*setup a temporary file*/
    if((strcpy(tempfile_nm,tempnam("/tmp","pgr"))) == NULL) {
		printf("\nThis program could not generate a temporary filename.\n");
		printf("The program cannot continue with this weird situation.\n");
		printf("Call the SysAdmin.  Press <ENTER> to exit...");
        key=0;
        while(! key)
            key=getakey();
        endwin();
        return;
    }

    if(argc<2) {
        printw("Missing input file name.\n");
        printw("Cannot continue.\n");
        printw("Syntax: %s <filename>\n",argv[0]);
        printw("Press <ENTER> to exit...");
        refresh();
        key=0;
        while(! key)
            key=getakey();
        endwin();
        return;
    }
    strcpy(filein_nm,argv[1]);


    /*check for empty files and existance of file in Unix environment*/
    if(stat(filein_nm,&statbuff) < 0) {
        printf("Cannot locate file: '%s'.  Cannot continue.\n\r",filein_nm);
        printf("Press <ENTER> to exit.\n\r");
        while(! key)
            key=getakey();
        endwin();
        exit(1);
    }
    fil_size=statbuff.st_size;
    /* make sure file is NOT empty */
    if(fil_size==0) { /*check for empty file*/
        printf("File '%s' is empty.  Cannot continue.\r\n",filein_nm);
        printf("Press <ENTER> to exit.\r\n");
        while(! key)
            key=getakey();
        endwin();
        exit(1);
    }


    /*if we get this far, and we cannot open the file, that means that the*/
    /*user may not have permission to read the file.*/
    if((filein=fopen(filein_nm,"r"))==NULL) {
        printw("Cannot open file: '%s' (permission?).\r\n",filein_nm);
        printw("Syntax: %s <filename>\r\n",argv[0]);
        printw("Press <ENTER> to exit...");
        refresh();
        key=0;
        while(! key)
            key=getakey();
        endwin();
        return;
    }


/****************************************************************************/
    printw("Reading file %s (%lu bytes).\n(Each period = 1000 lines of text): ",
filein_nm,fil_size);
    refresh();
    strcpy(srchstr,"");
    current=0;mbegin=0;mend=0;done=0;i=0;

/*  debugging
    while((c=fgetc(filein)) != EOF) {
        printf("%c",c);
    }
    endwin();
    exit(1);
*/
    while(((c=fgetc(filein)) != EOF)&&(! done)) {
        /*check for illegal characters, our network doesn't always do 8 bits*/
        if(c>126) done=1; /* no 8 bit chars */
        /*disallow control characters except as listed. note that some prns*/
        /*may need to have this commented out, but also that some terminals*/
        /*may show strange characters on screen with this commented out!*/
        /*we leave this section commented out.  if the following check is*/
        /*compiled, standard text controls are allowed to pass, but anything*/
        /*else will cause an error condition and the utility will fail.*/
        /*
        if(c<32) {
            switch(c) {
                case TAB:case LF:case CR:case FF:case ESC: break;
                default: done=2;
            }
        }
        */
        if(i>maxlinelen-1) done=3;
        if(i>79) over80cols=TRUE;
        /*if we have a problem, say what it is, what line and char it is.*/
        /*this error message has proved usefull to DBAs so they can fix*/
        /*problems in imported data.*/
        if(done) {
            printw("There is a problem reading file %s.\n",filein_nm);
            switch(done) {
                case 1: printw("File contains high ASCII characters.\n");
                    printw("Illegal character is decimal %d.\n",c);
                    break;
                case 2: printw("File contains illegal control characters.\n");
                    printw("Illegal character is decimal %d.\n",c);
                    break;
                case 3: printw("File contains lines with > %d characters.\n",
maxlinelen-1);break;
            }
            printw("Please check line %lu, col %lu for problem.\n",linecounter+
1,i+1);
            beep();
            printw("Press <ENTER> to exit...");
            refresh();
            key=0;
            while(! key)
                key=getakey();
            endwin();
            return; /*outahere*/
        }
        switch(c) {
            case 9: /*tab character, we'll move over to next tab stop */
                j=0;
                while((tabs[j] <= i) && (j<16)) j++;
                for(;i<tabs[j];i++) line1[i]=' ';
                break;
            case 13:
                break; /*if CRs exist in DOS file, disgard for now*/
            case 10: /*LF means we got a Unix EOL, put it in memory, restart i*/

                line1[i]='\0'; /*terminate line*/
                /*8/25/91 use malloc() to get enough mem for 1 more line*/
                /*allocate memory for this line, make pline[linecounter] point*/

                /*to it, and then copy line1 to pline element. */
                pline[linecounter]=malloc(sizeof(char) * (strlen(line1)+1));
                if(pline[linecounter] == NULL ) {
                    printf("\nCannot allocate memory!\n");
                    printw("Ran out of memory in line %lu.\n",linecounter+1);
                    sleep(5);
                    endwin();
                    exit(1);
                }
                memcpy(pline[linecounter],line1,strlen(line1)+1);
                linecounter++; /* we just completed a line */
                if(linecounter>=MAXLINES) {
                    printf("\nFile too long (>%lu lines). Quitting.\n",MAXLINES)
;
                    endwin();
                    exit(1);
                }
                /*this is where we display progress dots during file load*/

                if((linecounter % 10000) == 0) {
                    printw("+");refresh();
                }
                else if((linecounter % 1000) == 0) {
                    printw(".");refresh();
                }
                i=0;
                break;
            default:
                line1[i++]=c;/* add this next char to current line*/
        }
    } /* end while c=fgetc - we're finished reading the source file*/
    fclose(filein);
    printw("\n");
    refresh();

    /*initialize screen counters*/
    last=linecounter-1;
    if(last > MAXROWS-1)
        lastopline=linecounter-MAXROWS;
    else
        lastopline=0;

    mbegin=mend=last;


/************************ main loop *****************************************/

    disp=1; /* (re)display screen. if(disp) then we have to redisplay screen */
    srch=0;
    clearscr();
    current=0;
    while(! done) {
        /**************** display routine *******************/
        /*if any key has been pressed, we set disp so we remember to*/
        /*refresh screen when we go thru here.*/
        if(disp) {
            clearscr();
            j=0;
            for(i=0;(i<MAXROWS) && (i<=last);i++) {
                if(((current+i)>=mbegin) && ((current+i)<=mend))
                    standout(); /* highlight the marked text*/
                else
                    standend();
                if(! shiftscr) { /* we handle scroll left/right */
                    strncpy(haflin,pline[current + i],79);
                } else {
                    if(strlen(pline[current + i]) < shiftscr) {
                        strcpy(haflin,"\n");
                    } else {
                        strncpy(haflin,pline[current + i] + shiftscr,79);
                    }
                }
                if(haflin[strlen(haflin)-1] != '\n')
                    printw("%s\n",haflin);
                else
                    printw("%s",haflin);
                standend(); /*need to turn it off for other print things*/
            }
            clearbottom();
            move2bottom();
            attrset(A_BOLD);
            /*if we put 80 chars in the last line, some terminals may do an */
            /*automatic up scroll, so  limit last line to 79 chars. or less*/
            printw("<<<<  PRESS 'q' TO QUIT OR 'h' FOR HELP (cols %02d-%03d:top
line %lu)  >>>>", shiftscr+1,shiftscr+79,current+1);
            attroff(A_BOLD);
            homecurs();
            refresh();

            homecurs();  /* includes curses refresh to display screen */
            logiclin=0;
            disp=0;
            /*if we've done a search, place cursor on hit line*/
            if(srch) { /* if we got a search active, do something? */
                j=0;i=0;
                while(! j) { /* find the first line with search string */
                    if(toupper(case_yn)=='Y')
                        j=fstrstr(pline[current+i],srchstr);/*if hit,j=1, else*/

                    if(toupper(case_yn)=='N')
                        j=fstrstri(pline[current+i],srchstr);
                    if(j) break;
                    godn();
                    logiclin++;i++;

                } /* end while ! j */
                srch=0;
            } /* end if srch */

        } /* end if disp */
/****** HERE WE CHECK FOR KEY PRESSES ********************************/
        key=0;
        while(! key)
            key=getakey();
        if(key) {
            /*Not all terminals have key labels such as HOME, END, Page Up,*/
            /*Page Down, etc.  And even if they do, such keys may not be*/
            /*properly coded in the TERMINFO terminal definition.  Therefore*/
            /*even tho we check for them here, they still might not work.*/
            /*Another problem is that PCs may have key tops labeled with*/
            /*such designations, but the particular terminal emulation*/
            /*being used may not actually allow those keys to return a*/
            /*byte pattern which represents the key with a functionalality*/
            /*indicative of the PC keytop label.  Its frustrating to try*/
            /*to explain this to your users, and even more frustrating when*/
            /*you cant do your usual system administrative magic to resolve*/
            /*these kinds of problems.  For example the F1 key is an */
            /*alternative HELP key.  But not all TERMINFO descriptions */
            /*define the F1 key.  Also, eventho an IBM PCclone has an F1*/
            /*key, the vt100 emulation may not return the byte pattern*/
            /*for the original vt100 PF1 key - the user may have to press*/
            /*ALT-F1 to actually emulate the vt100 PF1 key.  The SysAdmin*/
            /*will have to modify the help() function to provide keytop*/
            /*label descriptions appropriate for their terminal environment.*/
            switch(key) {
                /*right one column: right arrow, p, P */
                /*left one column:  left arrow, o, O */
                /*right shift screen: ] */
                /*left shift screen: [ */
                /*action: a, A (goto download screen) */
                /*search: s, S */
                /*search next: n, N */
                /*goto beginning of doc: HOME, b, B */
                /*goto end of doc: END, e, E */
                /*up one line: up arrow, i, I */
                /*down one line: down arrow, k, K*/
                /*previous page: PAGE UP, u, U */
                /*next page: PAGE DOWN, j, J, <SPACEBAR> */
                /*quit: q, Q, x, X */
                /*help: F1, h, H */
                /*mark beginning of selected text: mb, Mb, mB, MB */
                /*mark end of selected text: me, Me, mE, ME */

            case KEY_RIGHT: case 'p': case 'P':
                      if(x < 79) gorit();
                      if(x==79) {
                          switch(shiftscr) { /* shift right */
                              case  0: shiftscr=64;break;
                              case 64: shiftscr=131;break;
                              case 131: shiftscr=0; break;
                          }
                          x=1;
                          disp=1;
                      }
                      break;
            case ']': /* shift right */
                      switch(shiftscr) { /* move depending on current status*/
                          case  0: shiftscr=64;break;
                          case 64: shiftscr=131;break;
                          case 131: shiftscr=0; break;
                      }
                      disp=1;
                      break;
            case KEY_LEFT: case 'o': case 'O':
                      if(x > 1) golft();
                      if(x==1) {
                          switch(shiftscr) { /* shift left */
                              case 0:  break;
                              case 64: shiftscr=0; break;
                              case 131: shiftscr=64;break;
                          }
                          disp=1;
                      }
                      break;
            case '[': /* shift left - move depending on current status*/
                      switch(shiftscr) {
                          case 0:  break;
                          case 64: shiftscr=0; break;
                          case 131: shiftscr=64;break;
                      }
                      disp=1;
                      break;

            case 'a': case 'A': /* do something with marked text */
                      clearscr();
                      disp=1;
                      /*this check for mbegin > mend should be moved to the */
                      /*'m' switch someday!*/
                      if(mbegin > mend) {
                          printw("The End Mark occurs before the Begin Mark.\n")
;
                          printw("Please remark the text.\n");
                          printw("Press <ENTER> to continue...");
                          refresh();
                          key=0;
                          while(! key)
                              key=getakey();
                          mbegin=mend=last;
                          break; /*leave this case*/
                      }
                      printw("Activity options:\n\n");
                      if(over80cols) {
                          attrset(A_BLINK);
                          printw("  WARNING:  Contains lines > 80 columns.  Set
printer for compressed.\n");
                          attroff(A_BLINK);
                      }
                      printw("  You currently have [%lu] line(s) of Marked Text.
\n",mend-mbegin+1);
                      printw("  On 8.5 X 11 paper, at 62 lines per page, this
isabout [%lu] page(s).\n",((mend-mbegin)/62)+1);
                      printw("  However, some documents may already be page
formatted.\n\n");
                      printw(" Press 'c' to cancel this function.\n");
                      printw(" Press 's' to save marked text to Host file.\n");
                      printw(" Press 'd' to display marked text on screen for
printer logging/file capture.\n");

#ifdef CKERMIT
                      printw(" Press 'k' to use Kermit data transfer protocol.\
n\n");
                      /*the sysadmin may wish to add another file*/
                      /*transfer protocol selection at this point,*/
                      /*and use the kermit transfer code below as a*/
                      /*template for developing the Unix command line*/
                      /*to perform a transfer.*/
#endif /*CKERMIT*/
                      /*
                      printw("      Special message line 1.\n");
                      printw("      Special message line 2.\n");
                      printw("      Special message line 3.\n");
                      printw("      Special message line 4.\n");
                      printw("      Special message line 5.\n");
                      printw("      Special message line 6.\n");
                      */
                      printw("\n");
                      printw("Request > ");
                      key=0;
                      while (! key)
                          key=getakey();
                      nl();  /*set up tty for interactive kbd */
                      echo();
                      nocbreak();
                      printw("\n");
                      switch(key){
                          case 's': case 'S':
                              printw("Please enter Host file name: ");
                              refresh();
                              getstr(fileout_nm);
                              if((fileout=fopen(fileout_nm,"w"))==NULL) {
                                  printw("\nCannot open output file.\n");
                                  printw("Press <ENTER>");
                                  refresh();
                                  getstr(line1);
                                  break;
                              }
                              printw("\n Saving marked text to %s...\n",fileout_
nm);
                              refresh();

                              if((filein=fopen(filein_nm,"r"))==NULL) {
                                  printw("Cannot reopen file: '%s'.\r\n",filein_
nm);
                                  printw("This is weird!  Call SysAdmin.\r\n");
                                  printw("Press <ENTER> to continue...");
                                  refresh();
                                  key=0;
                                  while(! key)
                                      key=getakey();
                                  endwin();
                                  return;
                              }
                              i=0;
                              if(mbegin>0) {
                                  while(fgets(line1,255,filein) != NULL) {
                                      i++;
                                      if(i == mbegin) break;
                                  }
                              }
                              while(fgets(line1,255,filein) != NULL) {
                                  fputs(pline[i],fileout);
                                  fputc('\n',fileout);
                                  i++;
                                  if(i==mend+1) break;
                              }
                              fflush(fileout);
                              fclose(fileout);
                              fclose(filein);
                              printw("\nFile saved.  Press <ENTER> to return.\n"
);
                              getstr(line1);
                              break;

                          case 'd': case 'D':
                              printw("\Please prepare your PC or printer to
CAPTURE displayed text.\n");
                              printw("Press the <ENTER> key when you are ready..
.\n");
                              refresh();
                              gets(line1);

                              if((filein=fopen(filein_nm,"r"))==NULL) {
                                  printw("Cannot reopen file: '%s'.\r\n",filein_
nm);
                                  printw("This is weird!  Call SysAdmin.\r\n");
                                  printw("Press <ENTER> to continue...");
                                  refresh();
                                  key=0;
                                  while(! key)
                                      key=getakey();
                                  endwin();
                                  return;
                              }
                              i=0;
                              /*skip over a bunch of stuff*/
                              /*if mbegin past the beginning*/
                              if(mbegin > 0) {
                                  while(fgets(line1,255,filein) != NULL) {
                                      i++;
                                      if(i == mbegin) break;
                                  }
                              }
                              /*now get the good stuff*/
                              while(fgets(line1,255,filein) != NULL) {
                                  for(j=0;j<strlen(line1);j++) {
                                      switch(line1[j]) {
                                          case '\n':printf("\r\n");break;
                                          default:printf("%c",line1[j]);
                                      }
                                  }
                                  i++;
                                  if(i>mend) break;
                              }
                              fclose(filein);

                              printf("==========================================
=====================================\r\n");
                              printf("FINISHED WITH DISPLAY!  RETURN TERMINAL
ORPRINTER TO NORMAL MODE.\r\n");
                              printf("Press the <ENTER> key when you are ready
to go on...\007");
                              refresh();
                              getstr(line1);
                              break;

#ifdef CKERMIT
                          /*The Kermit download is a recent addition to this*/
                          /*utility.  By studying code, other protocols may*/
                          /*be added to the utility.  The latest C-Kermit*/
                          /*from Columbia Univ. (128.59.39.2) 5A(189) can*/
                          /*use large 9,024 byte packets making it very*/
                          /*efficient.*/
                          case 'k': case 'K': /*Kermit protocol*/
                              clearscr();
                              printw("Kermit Download.\n");
                              printw("Enter DOS filename (target).  \nUse
forward '/' slashes to indicate DOS directories.\n");
                              printw("  > ");
                              refresh();
                              getstr(dos_nm); /* reuse this string */
                              if((strcmp(dos_nm,"")) == 0) break; /*empty fname*
/
                              /*first put data in a host file*/
                              if((fileout=fopen(tempfile_nm,"w"))==NULL) {
                                  printw("\nCannot open tempfile.\n");
                                  printw("Press <ENTER>");
                                  refresh();
                                  getstr(line1);
                                  break;
                              }
                              if((filein=fopen(filein_nm,"r"))==NULL) {
                                  printw("Cannot reopen file: '%s'.\n",filein_
nm);
                                  printw("This is weird!  Call SysAdmin.\r\n");
                                  printw("Press <ENTER> to continue...");
                                  refresh();
                                  key=0;
                                  while(! key)
                                      key=getakey();
                                  endwin();
                                  return;
                              }
                              i=0;
                              /*skip over a bunch of stuff*/
                              if(mbegin>0) {
                                  while(fgets(line1,255,filein) != NULL) {
                                      i++;
                                      if(i == mbegin) break;
                                   }
                               }
                              /*now get the good stuff*/
                              while(fgets(line1,255,filein) != NULL) {
                                  fputs(line1,fileout);
                                  i++;
                                  if(i==mend+1) break;
                              }
                              fflush(fileout);
                              fclose(fileout);
                              fclose(filein);
                              /*prepare for kermit xfer*/
                              /*if you want to use some other protocol*/
                              /*just put together an appropriate*/
                              /*command line here, or add another*/
                              /*protocol selection.*/
                              strcpy(cmdline,"kermit -s ");
                              strcat(cmdline,tempfile_nm);
                              strcat(cmdline," -a ");
                              strcat(cmdline,dos_nm);
                              printw("kermit -s %s -a %s\n",tempfile_nm,dos_nm);

                              printw("Make your Kermit operate in TEXT file
typemode.\n");
                              refresh();
                              system(cmdline);
                              unlink(tempfile_nm);
                              printw("\n\nEnd Kermit session.  Press <ENTER> to
continue...");
                              refresh();
                              getstr(line1);
                              break;
#endif /*CKERMIT*/

                          default: beep();
                      } /* end action switch */

                      nonl(); /*restore controlled tty mode */
                      noecho();
                      cbreak();
                      break;

            case 's': case 'S': /*search for a string*/
                      clearbottom();
                      move2bottom();
                      nl();
                      echo();
                      nocbreak();
                      printw("Search string: ");
                      getstr(srchstr);
                      nonl();
                      noecho();
                      cbreak();
                      move2bottom();
                      clearbottom();
                      printw("Case sensitive search? (y/n): ");
                      case_yn=0;
                      while(! case_yn)
                          case_yn=getakey();
                      clearbottom();
                      /* search for string from 'current' position in array*/
                      clearbottom();
                      printw("Searching...");refresh();
                      j=0;i=current;
                      if((case_yn=='y') || (case_yn=='Y'))
                      if(toupper(case_yn)=='Y')
                          while((! j) && (i<=last))
                              if(fstrstr(pline[i++],srchstr)) j=1;
                      if(toupper(case_yn)=='N')
                          while((! j) && (i<=last))
                              if(fstrstri(pline[i++],srchstr)) j=1;
                      /*if we have a hit, i is now 1 past the hit line, so*/
                      /*we need to decrement i.  If no hit, decrementing i*/
                      /*is harmless.*/
                      i--;
                      clearbottom();
                      if(! j) {
                          printw("String not found.  Press <ENTER> to continue")
;
                          refresh();
                          case_yn=0;
                          while(! case_yn)
                              case_yn=getakey();
                          clearbottom();
                      }
                      else { /*we found a hit*/
                          /* backtrack to previous */
                          if((i==last) || (i==(last-1)) ) i--;
                          current=i;
                          if(current>lastopline) current=lastopline;
                          srch=1;
                      }
                      disp=1;
                      break;

            case 'n': case 'N':
                      /* since this is a continued search, need to start*/
                      /* on the next page. */
                      i=current+1;
                      clearbottom();
                      printw("Searching...");refresh();
                      j=0;
                      if(toupper(case_yn)=='Y')
                          while((! j) && (i<=last))
                              if(fstrstr(pline[i++],srchstr)) j=1;
                      if((case_yn=='n') || (case_yn=='N'))
                      if(toupper(case_yn)=='N')
                          while((! j) && (i<=last))
                              if(fstrstri(pline[i++],srchstr)) j=1;
                      /*if we have a hit, i is now 1 past the hit line, so*/
                      /*we need to decrement i.  If no hit, decrementing i*/
                      /*is harmless.*/
                      i--;
                      clearbottom();
                      if(! j) {
                          printw("String not found.  Press <ENTER> to continue")
;
                          refresh();
                          case_yn=0;while(! case_yn) case_yn=getakey();
                          clearbottom();
                      }
                      else { /*we found a hit*/
                          /* backtrack to previous */
                          if((i==last) || (i==(last-1)) ) i--;
                          current=i;
                          if(current > lastopline) current=lastopline;
                          srch=1;
                      }
                      disp=1;
                      break;

            case KEY_HOME:
            case 'b': case 'B': /* goto beginning of document */
                      current=0;
                      disp=1;
                      break;
            case KEY_END:
            case 'e': case 'E': /* goto end of document*/
                      current=lastopline;
                      disp=1;
                      break;
            case KEY_UP:
            case 'i': case 'I': /* up: if we're already at the top, dont move.*/

                      if(current+logiclin==0) {
                          beep();
                          break;
                      }
                      if((y==1) && (current+logiclin>0)) {
                          current-=MAXROWS;
                          if(current<0) current=0;
                          disp=1;/*re display screen */
                          break;
                      }
                      goup();
                      logiclin--;
                      break;

            case KEY_DOWN:
            case 'k': case 'K':
                      if( (y < MAXROWS) && (current+logiclin < last) ){
                          godn();
                          logiclin++;
                      }
                      else {
                          current+=MAXROWS;
                          if(current>=lastopline) {current=lastopline; beep();}
                          disp=1;
                      }
                      break;

            case KEY_PPAGE:
            case 'u': case 'U': /* pg up */
                      if(current==0) {
                          beep();
                          disp=1;
                          break;
                      }
                      current-=MAXROWS;
                      if(current<0) current=0;
                      disp=1;/*re display screen */
                      break;

            case KEY_NPAGE:
            case 'j': case 'J': case ' ': /*pg dn*/
                      if(current>=lastopline) {
                          beep();
                          break;
                      }
                      current+=MAXROWS;
                      if(current>=lastopline) current=lastopline;
                      disp=1;/*re display screen */
                      break;
            case 'q':case 'Q':case 'x':case 'X': /*quit*/
                      done=1;
                      break;
            case KEY_F0+(1): /* F1 key, weird syntax to make this work tho! */
            case 'h': case 'H':/* help screen */
                      clearscr();
                      help();
                      disp=1;
                      break;
            case 'm': case 'M': /*set a mark*/
                      clearbottom();
                      move2bottom();
                      printw("Press 'b' to set the begin mark, 'e' to set the
end mark: ");
                      key=0;
                      while(! key)
                          key=getakey();
                      clearbottom();
                      switch(key) {
                      case 'B': case 'b':
                          mbegin=current+logiclin;
                          break;
                      case 'E': case 'e':
                          mend=current+logiclin;
                          break;
                      default: beep();
                      } /* end switch */
                      disp=1;
                      break;

            default : /* undefined key */
                      beep();

            } /* end switch */
        } /*end if(key) */
    } /* end while ! done */
    clearscr();
    endwin();
    return;
} /* end of MAIN */

/********************************/
homecurs()
{
    x=1;y=1;
    move(y-1,x-1);
    refresh();
    return;
}

/********************************/
clearscr()
{
    standend();
    clear();
    refresh();
    homecurs();
    return;
}

/********************************/
godn()
{
    y++;
    move(y-1,x-1);  /* curses uses 0 relative cartisian positioning */
    refresh();
    return;
}

/********************************/
goup()
{
    y--;
    move(y-1,x-1);
    refresh();
    return;
}

/********************************/
gorit()
{
    x++;
    move(y-1,x-1);
    refresh();
    return;
}
/********************************/
golft()
{
    x--;
    move(y-1,x-1);
    refresh();
    return;
}
/********************************/
move2bottom()
{
    move(MAXROWS,0);
    refresh();
    return;
}

/********************************/
clearbottom()
{
    move2bottom();
    printw("
");
    move2bottom();
    refresh();
    return;
}

/********************************/
int getakey()
{
    int key=0;

	notimeout(stdscr,TRUE);
    key=getch();
    if(key==ERR) /*defined in curses.h as -1 */
        key=0;   /* to make key compatible with the big switch */
                 /*Curses will return a 2 byte integer value for arrow keys*/
                 /*and page keys.  For this to work, the Next Page (PgDn) and*/
                 /*Previous Page (PgUp) keys must be defined in the terminal's*/

                 /*TERMINFO terminal definition.*/
    return key;
}

/********************************/
help()
/*See notes earlier in code regarding keytop labels just before the*/
/*"switch(key)" code.  Not all terminals support keytop labels such as*/
/*F1, HOME, END, etc.  Therefore, we have taken a least common denominator*/
/*approach to keyboard support.  The SysAdmin may modify the key descriptions*/
/*below to suit the local terminal environment.*/

{
    int key;

    clearscr();
    attrset(A_BOLD);
    printw(" %s",pagerversion);
    printw(" HELP SCREEN: \n");
    attroff(A_BOLD);

    printw("  HELP (this screen)          : h (F1 may work)\n");
    printw("  QUIT                        : x, q\n");
    printw("  Cursor Up                   : i (UP arrow may work)\n");
    printw("  Cursor Down                 : k (DOWN arrow may work)\n");
    printw("  Scroll Left                 : [, o (LEFT arrow may work)\n");
    printw("  Scroll Right                : ], p (RIGHT arrow may work)\n");
    printw("  Previous Screen             : u (Prev Pg may work)\n");
    printw("  Next Screen                 : j, <SPACE> (Next Pg may work)\n");
    printw("  Mark Text Area              : m+b=mark begin; m+e=mark end\n");
    printw("  Search for screen with text : s\n");
    printw("  Find next search string     : n\n");
    printw("  *Action (Move Marked Text)  : a  (*see note below & next help
screen)\n");
    printw("  End of document             : e (END may work)\n");
    printw("  Beginning of document       : b (HOME may work)\n");


    attrset(A_BOLD);
    printw("  (PRESS Next Screen AT THIS TIME FOR ADDITIONAL HELP.\n");
    attroff(A_BOLD);
    printw("  * Functionality depends on terminal type.  All terminal
emulations\n");
    printw("    may use Kermit downloads, file capture, and printer capture.\n")
;
    printw("    Users of dumb terminals may capture data if printer is attached
to\n");
    printw("    the terminal.\n");

    attrset(A_BOLD);
    printw(" PRESS <ENTER> TO LEAVE HELP SCREEN BEFORE TYPING COMMAND: ");
    attroff(A_BOLD);

    key=0;
    while(! key)
       key=getakey();
    switch(key) {
        case KEY_NPAGE:
        case 'j': case 'J': case ' ': /*pg dn*/
            clearscr();
            printw("HELP SCREEN Page 2:\n");
            printw("\n");

            printw("Regarding \"Move Marked Text\" and Downloading data:  The
user may 'mark'\n");
            printw("one portion of the file currently being viewed using the 'm'
key.  The user is\n");
            printw("prompted to indicate either the 'b'eginning or 'e'nd of the
marked text.\n");
            printw("After marking an area, the user may download the text that
has been marked.\n");
            printw("How the text is downloaded depends on what kind of terminal
the user has.  If\n");
            printw("a PC terminal emulation is being used, the user may elect
touse Kermit\n");
            printw("download, file capture, or printer capture.  If the user
hasa dumb terminal,\n");
            printw("the user will need to 'capture' the data to an attached
printer.  Most dumb\n");
            printw("terminals have a function key combination that causes the
printer to copy\n");
            printw("data appearing on the screen.\n");

            attrset(A_BOLD);
            printw(" PRESS <ENTER> TO SEE NEXT HELP SCREEN: ");
            attroff(A_BOLD);
            refresh();
            attroff(A_BOLD);
            key=0;
            while(! key)
               key=getakey();
            clearscr();

            /*If a third help screen is unneeded, comment out from here...*/
            printw("HELP SCREEN Page 3:\n");
            printw("\n\nThird help screen may be added here.\n\n");
            attrset(A_BOLD);
            printw(" PRESS <ENTER> TO LEAVE HELP SCREEN BEFORE TYPING COMMAND: "
);
            attroff(A_BOLD);
            refresh();
            attroff(A_BOLD);
            key=0;
            while(! key)
               key=getakey();
            /*...to here. (end of commented out 3rd help screen)*/
            break;
        default: ; /*do nothing, fall thru*/
    } /*end switch in help*/
    return;
}

/********************************/
/*didn't have a library function for string search, so wrote these*/
int fstrstr(s1, s2) /* case sensitive search comparison */
char *s1, *s2;
{
    int i,slen1,slen2;

    slen1=strlen(s1);
    slen2=strlen(s2);

    for(i=0;i<(slen1-slen2+1);i++) {
        if(! strncmp(s1+i,s2,slen2))
            return 1; /* found a match */
    }
    return 0; /* no match found */

}
/********************************/
/* to ignore case on compare, we convert both strings to upper case first*/
int fstrstri(s1, s2) /* search version to ignore case */
char *s1, *s2;
{
    int i,slen1,slen2;
    char ss1[133],ss2[80];

    slen1=strlen(s1);
    slen2=strlen(s2);

    strcpy(ss1,s1);strcpy(ss2,s2);
    for(i=0;i<slen1;i++) {
        if(islower(ss1[i]))
            ss1[i]=_toupper(ss1[i]);
    }
    for(i=0;i<slen2;i++) {
        if(islower(ss2[i]))
            ss2[i]=_toupper(ss2[i]);
    }

    for(i=0;i<(slen1-slen2+1);i++) {
        if(! strncmp(ss1+i,ss2,slen2))
            return 1; /*we found a hit*/
    }
    return 0; /* no match found */

}

-- Cut Here   End of PAGER.C --


