/*
 * Symlink
 * Version:     4.0
 * File:        make_links.h
 * Date:        8/11/93
 * Authors:     CM King with AJ Rixon
 * Comment:     header for linking routines
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <string.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <malloc.h>
#include <unistd.h>

extern int level_limit;  /* directory search depth */
extern int present_level; /* current depth */
extern int backoff; /* preserve existing links (backoff) */
extern int ignore; /* overwrite existing links */
extern int trial;  /* test mode */
extern int ack;   /* acknowledge mode */
extern FILE *log_file; /* log file */
extern int errno;
extern char *sys_errlist[];
extern char tmp_name[];

/* make a new link */
extern void make_link(/* char *target, char *source */);
/* link to within a directories */
extern void make_link_type(/* char *link_source, char *target, LINK_TYPE multiple_type */);
/* link to subdirectories */
extern void make_sub_multi_links(/* char *source, char *target, char *subdirs */);
/* read desc file and call link function */
extern void make_dir_links(/* char *target, char *link_files_list */);
/* tests if a directory exists */
extern int test_dir_exist(/* char *dir_name, char *root_root */);
/* ask user for confirmation of action */
extern int yesno();
extern int readlink();
extern int lstat();

#define LOGFILE "linker.log" /* name for a log file */
#define YES 1 /* responses from yesno() query function */
#define NO 0
#ifndef MAXNAMELEN              /* not in BSD */
#define MAXNAMELEN 256
#endif
#define FSERR -1 /* filesystem routines error value */
#define DEFAULT_PERMS  0755 /* default permissions for created directories */
