static char SCCSID[] = "@(#)screencpy.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC myGC;

/*
 * screen->screen copy area
 *
 * used for moving windows, scrolling
 */
screencopy_setup(dpy, win, dummy)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);

	myGC = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC) return 1;
	XSetForeground(dpy, myGC, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC, BlackPixel(dpy, screen));
	XDrawImageString(dpy, win, myGC, 0, 5, "copy", 4);

	return 0;
}

screencopy_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, myGC);
}

screencopy_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int ncopy;

	ncopy= 0;
	while (benchRunning) {
	    XCopyArea(dpy, win, win, myGC, 0, 0, len, len, 16, 16);
	    XCopyArea(dpy, win, win, myGC, 0, 0, len, len, 16, 16);
	    XCopyArea(dpy, win, win, myGC, 0, 0, len, len, 16, 16);
	    XCopyArea(dpy, win, win, myGC, 16, 16, len, len, 0, 0);
	    XCopyArea(dpy, win, win, myGC, 16, 16, len, len, 0, 0);
	    XCopyArea(dpy, win, win, myGC, 16, 16, len, len, 0, 0);
	    if (sync) XSync(dpy, 0);
	    ncopy += 6;
	}
	return ncopy;
}

screencopy_msg(deltaT, ncopy, len, rate)
double rate;
{
	printf("COPYAREA (SCREEN->SCREEN)\n");
	printf("\n");
	printf("%d copies with %d pixel sides in %d secs\n",
				ncopy, len, deltaT);
	printf("rate = %8.2f copies/sec (%d Pixels/sec)\n",
				rate, (ncopy*len*len)/deltaT);
}
