typedef struct  FileType
    {
    const char    *Extension;
    char    **Array;
    int     NFiles;
    }           FileType;


int     FileExists(const char *PathName)
    {
    int     Exists;
    FILE    *This = fopen(PathName, "r");
    Exists  = (This != NULL);
    fclose(This);
    return Exists;
    }


void    PutString(int Device, char *String)
    {
    WRITE(Device, String, strlen(String));
    }
void    PutDec(int Device, int Value)
    {
    char    String[2];

    if(Value >= 10)
        PutDec(Device, Value/10);
    String[0]   = '0' + Value%10;
    String[1]   = '\0';
    PutString(Device, String);
    }

/* ErrorOutput() - write string to stderr */
int ErrorCount;
void    ErrorOutput(const char *String)
    {
    WRITE(2, String, strlen(String));
    ++ErrorCount;
    }



/* FindFileName() - return point to filename in path */
char    *FindFileName(const char *Path)
    {
    const char  *BackSlash;
    const char  *ForwardSlash;

    ForwardSlash    = strrchr(Path, '/');
    if(ForwardSlash)
        ++ForwardSlash;
    else
        ForwardSlash    = Path;
    BackSlash   = strrchr(ForwardSlash, '\\');
    if(BackSlash)
        return (char *)(BackSlash+1);
    else
        return (char *)ForwardSlash;
    }

/* FindExtension() - return pointer to extension in filename */
char    *FindExtension(const char *Path)
    {
    const char  *FileName;
    const char  *Dot;

    FileName    = FindFileName(Path);
    Dot         = strrchr(FileName, '.');

    if(Dot)
        return (char *)(Dot + 1);
    else
        return (char *)(FileName + strlen(FileName));
    }

void    EchoArgs(char **Args, int NArgs)
    {
    int     i;

    for(i = 0; i < NArgs; ++i)
        fprintf(stdout, "%s%s", i?" ":"", Args[i]);
    fprintf(stdout, "\n");
    }

void    CopyFileName(const char *From, char *To)
    {
    From    = FindFileName(From);
    while(*From && *From != '.')
        *To++   = *From++;
    *To++   = '\0';
    }

void    CopyPathName(const char *From, char *To)
    {
    const char *File = FindFileName(From);
    while(From < File)
        *To++   = *From++;
    CopyFileName(From, To);
    }
/* SortFiles() - produce sorted list of files by extension */
void    SortFiles(char **Input, FileType *Output,
    const char *Extension, const char *Default)
    {
    char    **Files;
    int     DoingDefault;
    int     Sorted = 0;

    while(*Extension)
        {
        Output->NFiles      = 0;
        Output->Array       = Input + Sorted;
        Output->Extension   = Extension;
        DoingDefault        = !STRICMP(Extension, Default);
        for(Files = Input; *Files; ++Files)
            {
            if(!STRICMP(Extension, FindExtension(*Files))
                ||(DoingDefault && !STRICMP("", FindExtension(*Files))))
                {
                char    *Temp;
                Temp            = Input[Sorted];
                Input[Sorted]   = *Files;
                *Files          = Temp;
                ++Sorted;
                ++Output->NFiles;
                }
            }
        ++Output;
        Extension   += strlen(Extension)+1;
        }
    }


#if 0
int     OpenForWrite(const char *FileName)
    {
    int     FileHandle;

    FileHandle  = OPEN(FileName, O_RDWR|O_CREAT|O_TRUNC, S_IWRITE|S_IREAD);
    if(FileHandle < 0)
        {
        ErrorOutput("Can't create file '");
        ErrorOutput(FileName);
        ErrorOutput("'!\r\n");
        exit(EXIT_FAILURE);
        }
    return FileHandle;
    }

#endif
void    GenModDef(char *Path, int Library)
    {
    FILE    *ModFile;
    char    FileName[16];

    CopyFileName(Path, FileName);
    strcat(FileName, ".def");
    ModFile = fopen(FileName, "r");
    if(ModFile != NULL) /* if file already exists, use it */
        fclose(ModFile);
    else
        {
        ModFile = fopen(FileName, "w");
        if(ModFile == NULL)
            {
            fprintf(stderr, "Can't create '%s'.\n", FileName);
            exit(EXIT_FAILURE);
            }
        else
            {
            CopyFileName(Path, FileName);
            fprintf(ModFile, "%-14.14s%s\n", Library ? "LIBRARY"
                : "NAME", FileName);
            fprintf(ModFile, "DESCRIPTION  'Default module "
                "definition file for %s.%s.'\n",
                FileName, Library ? "lib" : "exe" );
            fprintf(ModFile, "EXETYPE       WINDOWS\n");
            fprintf(ModFile, "CODE          PRELOAD MOVEABLE DISCARDABLE\n");
            fprintf(ModFile, "DATA          PRELOAD MOVEABLE %s\n",
                Library ? "SINGLE" : "MULTIPLE" );
            fprintf(ModFile, "HEAPSIZE      4096\n");
            if(!Library)
                fprintf(ModFile, "STACKSIZE     16384\n");
            else
                {
#if 0 /* we're assuming you're using __export and want to allow
         you to create a DLL that does not have a WEP  */  
                fprintf(ModFile, "EXPORTS\n");
                fprintf(ModFile, "    WEP           @1       RESIDENTNAME\n");
#endif
                }
            fclose(ModFile);
            }
        }    
    }

char    *SearchPath(const char *Paths, const char *File, char *Path)
    {
    const char *Rover = Paths;
    while(*Rover)
        {
        char    *SearchPath = Path;
        while(*Rover && *Rover != ';')
            *SearchPath++   = *Rover++;
        *SearchPath++ = '\\';
        strcpy(SearchPath, File);
        if(FileExists(Path))
            return Path;
        else if(*Rover == ';')
            ++Rover;
        }
    return NULL;
    }
