/**
 * Dynamically loaded libtiff support.
 *
 * This file is automatically generated by the gen_dynlibtiff.py script.
 * 
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Contributor(s): Jonathan Merritt.
 *
 * ***** END GPL LICENSE BLOCK *****
 */
 
/**
 * To use the dynamic libtiff support, you must initialize the library using:
 *	libtiff_init()
 * This attempts to load libtiff dynamically at runtime.  G.have_libtiff will
 * be set to indicate whether or not libtiff is available.  If libtiff is
 * not available, Blender can proceed with no ill effects, provided that
 * it does not attempt to use any of the libtiff_ functions.  When you're
 * finished, close the library with:
 *	libtiff_exit()
 * These functions are both declared in IMB_imbuf.h
 *
 * The functions provided by dyn_libtiff.h are the same as those in the
 * normal static / shared libtiff, except that they are prefixed by the 
 * string "libtiff_" to indicate that they belong to a dynamically-loaded 
 * version.
 */
#ifndef DYN_LIBTIFF_H
#include "tiffio.h"
extern TIFF* (*libtiff_TIFFClientOpen)(const char*, const char*, thandle_t, TIFFReadWriteProc, TIFFReadWriteProc, TIFFSeekProc, TIFFCloseProc, TIFFSizeProc, TIFFMapFileProc, TIFFUnmapFileProc);
extern void (*libtiff_TIFFClose)(TIFF*);
extern int (*libtiff_TIFFGetField)(TIFF*, ttag_t, ...);
extern TIFF* (*libtiff_TIFFOpen)(const char*, const char*);
extern int (*libtiff_TIFFReadRGBAImage)(TIFF*, uint32, uint32, uint32*, int);
extern int (*libtiff_TIFFSetField)(TIFF*, ttag_t, ...);
extern tsize_t (*libtiff_TIFFWriteEncodedStrip)(TIFF*, tstrip_t, tdata_t, tsize_t);
extern void (*libtiff__TIFFfree)(tdata_t);
extern tdata_t (*libtiff__TIFFmalloc)(tsize_t);
#endif /* DYN_LIBTIFF_H */

