#ifndef BUILTIN_CLASSES_H
#define BUILTIN_CLASSES_H

#include "Grammar.h"
#include "CL_List.h"



void       AddBuiltinClasses();



class NativeList : public NativeInstance {  // to replace class 'List'
protected:
  CL_List<Expr*>     _elements;
public:
                     NativeList();
                     NativeList(CL_List<Expr*>& args);  // constructor
                     ~NativeList();
  NativeList*        Copy();
  void               Print(ostream& os=cout);
  void               Inspect(ostream& os=cout);
  Literal*           GetVal(char*)              {return 0;}
  void               SetVal(char*, Literal& v)  {}
  Symbol*            Lookup(char* name)         {return 0;}
  Symbol*            Find(char* name)           {return 0;}
  CL_List<Expr*>*    GetNativeList()            {return &_elements;}
  void               Dump(ostream&);
  void               Read(istream&);


  Expr*              Length(CL_List<Expr*>&     args);
  Expr*              Add(CL_List<Expr*>&        args);
  Expr*              At(CL_List<Expr*>&         args);
  Expr*              AddFirst(CL_List<Expr*>&   args);
  Expr*              AtPut(CL_List<Expr*>&      args);
  Expr*              Delete(CL_List<Expr*>&     args);
};




class NativeStruct : public NativeInstance {
protected:
  CL_List<Pair*>     _elements;
                     NativeStruct(CL_List<Pair*>& args);
public:
                     NativeStruct(CL_List<Expr*>& args);  // constructor
                     NativeStruct();
                     ~NativeStruct();
  CL_List<Pair*>*    GetNativeStruct()      {return &_elements;}
  NativeStruct*      Copy();
  void               Print(ostream& os=cout);
  void               Inspect(ostream& os=cout);
  Literal*           GetVal(char*);
  void               SetVal(char*, Literal& v);
  Symbol*            Lookup(char* name)         {return 0;}
  Symbol*            Find(char* name);
  void               Dump(ostream&);
  void               Read(istream&);


  Expr*              Length(CL_List<Expr*>&     args);
  Expr*              Add(CL_List<Expr*>&        args);
  Expr*              At(CL_List<Expr*>&         args);
  Expr*              AddFirst(CL_List<Expr*>&   args);
  Expr*              AtPut(CL_List<Expr*>&      args);
  Expr*              Delete(CL_List<Expr*>&     args);
};




class NativeUnion : public NativeInstance {
protected:
  char*              _name;
  Literal*           _val;
public:
                     NativeUnion(char* name, Literal* v);
                     NativeUnion(CL_List<Expr*>& args);  // constructor
                     ~NativeUnion();
  NativeUnion*       Copy();
  void               Print(ostream& os=cout);
  void               Inspect(ostream& os=cout);
  char*              GetName()                  {return _name;}
  Literal*           GetVal(char* s=0);
  void               SetVal(char*, Literal& v);
  Symbol*            Lookup(char* name)         {return 0;}
  Symbol*            Find(char* name);
  void               Dump(ostream&);
  void               Read(istream&);
};



#endif

