#ifndef CL_DICT
#define CL_DICT
#include "CL_List.h"

template<class Key, class Val> class CL_Assoc;
template<class Key, class Val> class CL_Dict;

/*-----------------------------------------------*/
/* Association                                   */
/*-----------------------------------------------*/

template<class Key, class Val> class CL_Assoc {
  Key                   key;
  Val                   val;
  public:
                        CL_Assoc(Key, Val);
  virtual               ~CL_Assoc() {}
  Key                   GetKey()           {return key;}
  Val&                  GetVal()           {return val;}
  int                   operator==(CL_Assoc<Key,Val>&);
  friend ostream&       operator<<(ostream&, CL_Assoc<Key,Val>&);
};

template<class Key, class Val> CL_Assoc<Key,Val>::CL_Assoc(Key k, Val v)
                                                     : key(k), val(v) {}



template<class Key, class Val>
int CL_Assoc<Key,Val>::operator==(CL_Assoc<Key,Val>& ass) {
  if(key==ass.GetKey() && val==ass.GetVal())
    return true;
  return false;
}

template<class Key, class Val>
ostream& operator<<(ostream& os, CL_Assoc<Key,Val>& ass) {
  return os << "(" << ass.GetKey() << "  ->  " << ass.GetVal() << ")";
}


/*-----------------------------------------------*/
/* Dictionary                                    */
/*-----------------------------------------------*/


template<class Key, class Val> class CL_Dict : public CL_List<CL_Assoc<Key,Val>* > {
  public:
                        ~CL_Dict();
  bool                  Add(Key, Val, insertion_mode=::replace, insertion_order=::tail);
  bool                  ContainsKey(Key&);
  Key                   FindKey(Val);
  CL_Assoc<Key,Val>*    FindKeyAsAssoc(Val);
  Val                   FindVal(Key);
  CL_Assoc<Key,Val>*    FindValAsAssoc(Key);
  void                  Remove(Key);			
  void                  RemoveAll();			
};


template<class Key, class Val> 
CL_Dict<Key,Val>::~CL_Dict() {
  for(CL_Node<CL_Assoc<Key,Val>*>* n=first; n; n=n->GetNext())
    delete n->GetElement();
}

template<class Key, class Val>
bool CL_Dict<Key,Val>::Add(Key k, Val val, insertion_mode m, insertion_order order) {
  CL_Assoc<Key, Val>* item=FindValAsAssoc(k);
  if(item) {  // key already in dictionary
    if(m == ::replace) {
      item->GetVal()=val; 
      return true;
    }
    return false;
  }
  else {  // key *not* in dictionary
    CL_Assoc<Key,Val>* ass=new CL_Assoc<Key,Val>(k,val);
    return CL_List<CL_Assoc<Key,Val>*>::Add(ass, order);
  }
}


template<class Key, class Val>
bool CL_Dict<Key,Val>::ContainsKey(Key& k) {
  /* CL_Node<CL_Assoc<Key,Val>>* t doesn't work !! */
  for(CL_Node<CL_Assoc<Key,Val>*>* tmp=first; tmp; tmp=tmp->GetNext())
    if(IsEqual(tmp->GetElement()->GetKey(), k))
      return true;
  return false;
}


template<class Key, class Val>
Key CL_Dict<Key,Val>::FindKey(Val v) {
  for(CL_Node<CL_Assoc<Key,Val>*>* tmp=first; tmp; tmp=tmp->GetNext())
    if(IsEqual(tmp->GetElement()->GetVal(), v))
      return tmp->GetElement()->GetKey();
  return 0;
}

template<class Key, class Val>
CL_Assoc<Key,Val>* CL_Dict<Key,Val>::FindKeyAsAssoc(Val v) {
  for(CL_Node<CL_Assoc<Key,Val>*>* tmp=first; tmp; tmp=tmp->GetNext())
    if(IsEqual(tmp->GetElement()->GetVal(), v))
      return tmp->GetElement();
  return 0;
}


template<class Key, class Val>
Val CL_Dict<Key,Val>::FindVal(Key k) {
  for(CL_Node<CL_Assoc<Key,Val>*>* tmp=first; tmp; tmp=tmp->GetNext())
    if(IsEqual(tmp->GetElement()->GetKey(), k))
      return tmp->GetElement()->GetVal();
  return 0;
}

template<class Key, class Val>
CL_Assoc<Key,Val>* CL_Dict<Key,Val>::FindValAsAssoc(Key k) {
  for(CL_Node<CL_Assoc<Key,Val>*>* tmp=first; tmp; tmp=tmp->GetNext())
    if(IsEqual(tmp->GetElement()->GetKey(), k))
      return tmp->GetElement();
  return 0;
}


template<class Key, class Val>
void CL_Dict<Key,Val>::Remove(Key k) {
  CL_Assoc<Key,Val>* a=FindValAsAssoc(k);
  if(a) {
    CL_List<CL_Assoc<Key,Val>*>::Remove(a);
  }
}



template<class Key, class Val> 
void CL_Dict<Key,Val>::RemoveAll() {
  for(CL_Node<CL_Assoc<Key,Val>*>* n=first; n; n=n->GetNext())
    delete n->GetElement();
  CL_List<CL_Assoc<Key,Val>*>::RemoveAll();
}


#endif
