#include "Contact.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <iostream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <time.h>
#include <strings.h>


/* Sends a UDP packet to the server */
short SendUsageToServer(char* progname, char* msg, int port_number) {
  int          socket_descr, rc;
  sockaddr_in  server_addr, client_addr;
  char         buffer[0xff];
  char*        host_name="9.4.21.181";  // adlerhorn@zurich.ibm.com

  socket_descr=socket(AF_INET, SOCK_DGRAM, 0);
  if(socket_descr == -1)
    return 0;

  bzero((char*)&server_addr, sizeof(server_addr));
  server_addr.sin_family=AF_INET;
  server_addr.sin_addr.s_addr=inet_addr(host_name);
  server_addr.sin_port=htons(port_number);
  #ifndef __linux__
  server_addr.sin_len=sizeof(server_addr);
  #endif

  // Now get a port for the client to send messages to the server:
  // Setting the port to 0 assigns a unique client port

  bzero((char*)&client_addr, sizeof(client_addr));
  client_addr.sin_family=AF_INET;
  client_addr.sin_addr.s_addr=htonl(INADDR_ANY);
  client_addr.sin_port=htons(0);
  #ifndef __linux__
  client_addr.sin_len=sizeof(client_addr);
  #endif

  rc=bind(socket_descr, (sockaddr*)&client_addr, sizeof(client_addr));
  if(rc == -1) {
#ifdef CONTACT
    perror("contact problem");
#endif
    close(socket_descr);
    return 0;
  }
  time_t   tim;
  char*    str_time="<unknown time>";
  time(&tim);
  str_time=ctime(&tim);    

  /* fill in buffer */
  if(msg)
    sprintf(buffer, "%s: %s, %s", progname, msg, str_time);
  else {
    char userid[32], user_host[128], *ret;
    ret=cuserid(userid);
    if(!ret)
      strcpy(userid, "<unknown>");
    
    rc=gethostname(user_host, sizeof(user_host));
    if(rc == -1)
      strcpy(user_host, "<unknown host>");
    
    sprintf(buffer, "%s: %s, %s, %s", 
	    progname, userid, user_host, str_time);
  }

  rc=sendto(socket_descr, buffer, sizeof(buffer), 0, (sockaddr*)&server_addr, sizeof(sockaddr_in));
  if(rc < 0) {
#ifdef CONTACT
    perror("contact problem");
#endif
    close(socket_descr);
    return 0;
  }
  close(socket_descr);
  return 1;
}
